package com.jhscale.common.model.device.other;

import com.jhscale.common.annotation.DataClass;
import com.jhscale.common.model.device.DBContent;
import com.jhscale.common.model.device.DData;

import java.util.Arrays;

import static com.jhscale.common.model.device.DConstant.PUBLIC_LINE_SPLIT;
import static com.jhscale.common.model.device.DConstant.SPP;

/**
 * @author wang lie
 * @version 1.0
 * @projectName common
 * @title SpDWL
 * @description
 * @create 2023/12/25 12:40
 */
@DataClass
public class DSpDWLV1<T extends DSpDWLV1> extends DData<T> implements DSpDWL<T> {

    private String key;

    private String name;

    private String kid;

    private String content;

    /**
     * @description: 公开协议 组包 不使用反射
     **/
    @Override
    public StringBuilder Public_Package_No_Reflex() {
        return super.Public_Package_No_Reflex()
                .append(this.to_append(this.kid))
                .append(this.to_append(this.content))
                .append(PUBLIC_LINE_SPLIT);
    }

    /**
     * @param all_fields
     * @description: 直接赋值
     */
    @Override
    public T Public_UnPackage_No_Reflex(String[] all_fields) {
        this.setKey(this.toString(all_fields, 0));
        this.setNo(this.toInteger(all_fields, 1));
        this.setKid(String.format("%s\t%s", this.getKey(), this.getNo()));
        this.setName(this.toString(all_fields, 2));
        try {
            String[] content_arr = Arrays.copyOfRange(all_fields, 3, all_fields.length);
            StringBuilder builder = new StringBuilder(this.getName());
            for (String a : content_arr) {
                builder.append("\t").append(a);
            }
            this.setContent(builder.toString());
        } catch (Exception e) {
            StringBuilder builder = new StringBuilder();
            for (String field : all_fields) {
                builder.append(field).append(" ");
            }
            System.err.println(builder.toString() + e.getMessage());
        }
        return (T) this;
    }

    @Override
    public DBContent toDBContent() {
        return new DBContent(SPP, this.kid, this.content);
    }

    public String getKey() {
        return key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getKid() {
        return kid;
    }

    public void setKid(String kid) {
        this.kid = kid;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }
}
