package com.jhscale.common.model.device.plu;

import com.jhscale.common.model.device.plu.inner.*;
import com.jhscale.common.model.device.plu.module.DSpecification;
import com.jhscale.common.utils.DPLUUtils;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author lie_w
 * @title: PLU
 * @projectName common
 * @description: 设备PLU信息
 * @date 2021-02-269:01
 */
public class DPLUV1<T extends DPLUV1> implements DPLU<DPLUV1> {

    @ApiModelProperty(value = "PLU编号", name = "pluNo")
    private Long pluNo;
    @ApiModelProperty(value = "PLU系统唯一编号", name = "pluCode")
    private Long pluCode;
    @ApiModelProperty(value = "商品名称", name = "pluName")
    private String pluName;
    @ApiModelProperty(value = "商品上架状态", name = "pluState", example = "1-下架 2-上架，3-停售，4-缺货")
    private String pluState;
    @ApiModelProperty(value = "PLU序号", name = "sortOrder")
    private Integer sortOrder;
    @ApiModelProperty(value = "简写", name = "simple")
    private String simple;
    @ApiModelProperty(value = "库存单位", name = "unit")
    private DUnit unit;
    @ApiModelProperty(value = "规格", name = "specification")
    private DSpecification specification;
    @ApiModelProperty(value = "图片", name = "pictures")
    private String pictures;
    @ApiModelProperty(value = "单价", name = "price")
    private BigDecimal price;

    @ApiModelProperty(value = "货号", name = "number")
    private Integer number;
    @ApiModelProperty(value = "索引条码", name = "indexBar")
    private String indexBar;
    @ApiModelProperty(value = "使用期信息", name = "useDate")
    private DUseDate useDate;
    @ApiModelProperty(value = "成本", name = "costTrade")
    private BigDecimal costTrade;
    @ApiModelProperty(value = "皮重", name = "trae")
    private BigDecimal trae;
    @ApiModelProperty(value = "主要类别", name = "category")
    private DCategory category;
    @ApiModelProperty(value = "次要类别编号", name = "secondCategoryIds")
    private String secondCategoryIds;
    @ApiModelProperty(value = "次要类别", name = "secondaryCategories")
    private List<DCategory> secondaryCategories;
    @ApiModelProperty(value = "打印格式1", name = "printInfo1")
    private DPrintInfo printInfo1;
    @ApiModelProperty(value = "打印格式2", name = "printInfo2")
    private DPrintInfo printInfo2;
    @ApiModelProperty(value = "文本内容 条码秤最大长度8 收银秤另说", name = "texts")
    private List<String> texts;
    @ApiModelProperty(value = "税率", name = "taxRate")
    private BigDecimal taxRate;
    @ApiModelProperty(value = "位图信息", name = "bitmap")
    private DBitmap bitmap;
    @ApiModelProperty(value = "销售日期", name = "saleDate")
    private DSaleDate saleDate;
    @ApiModelProperty(value = "销售时间", name = "saleTime")
    private DSaleTime saleTime;
    @ApiModelProperty(value = "包装日期", name = "packDate")
    private DPackDate packDate;
    @ApiModelProperty(value = "包装时间", name = "packTime")
    private DPackTime packTime;
    @ApiModelProperty(value = "手动折扣", name = "手动折扣")
    private String manualDiscount;
    @ApiModelProperty(value = "自动折扣1", name = "autoDiscount1")
    private String autoDiscount1;
    @ApiModelProperty(value = "自动折扣2", name = "autoDiscount2")
    private String autoDiscount2;
    @ApiModelProperty(value = "自动折扣3", name = "autoDiscount3")
    private String autoDiscount3;
    @ApiModelProperty(value = "自动折扣4", name = "autoDiscount4")
    private String autoDiscount4;

    public DPLUV1() {
    }

    public DPLUV1(String data) {
        this.parse(data, true);
    }

    public DPLUV1(String data, boolean base64) {
        this.parse(data, base64);
    }

    public Long getPluNo() {
        return pluNo;
    }

    public void setPluNo(Long pluNo) {
        this.pluNo = pluNo;
    }

    public Long getPluCode() {
        return pluCode;
    }

    public void setPluCode(Long pluCode) {
        this.pluCode = pluCode;
    }

    public String getPluName() {
        return pluName;
    }

    public void setPluName(String pluName) {
        this.pluName = pluName;
    }

    public String getPluState() {
        return pluState;
    }

    public void setPluState(String pluState) {
        this.pluState = pluState;
    }

    public Integer getSortOrder() {
        return sortOrder;
    }

    public void setSortOrder(Integer sortOrder) {
        this.sortOrder = sortOrder;
    }

    public DUnit getUnit() {
        return unit;
    }

    public void setUnit(DUnit unit) {
        this.unit = unit;
    }

    public String getSimple() {
        return simple;
    }

    public void setSimple(String simple) {
        this.simple = simple;
    }

    public DSpecification getSpecification() {
        return specification;
    }

    public void setSpecification(DSpecification specification) {
        this.specification = specification;
    }

    public String getPictures() {
        return pictures;
    }

    public void setPictures(String pictures) {
        this.pictures = pictures;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public Integer getNumber() {
        return number;
    }

    public void setNumber(Integer number) {
        this.number = number;
    }

    public String getIndexBar() {
        return indexBar;
    }

    public void setIndexBar(String indexBar) {
        this.indexBar = indexBar;
    }

    public DUseDate getUseDate() {
        return useDate;
    }

    public void setUseDate(DUseDate useDate) {
        this.useDate = useDate;
    }

    public BigDecimal getCostTrade() {
        return costTrade;
    }

    public void setCostTrade(BigDecimal costTrade) {
        this.costTrade = costTrade;
    }

    public BigDecimal getTrae() {
        return trae;
    }

    public void setTrae(BigDecimal trae) {
        this.trae = trae;
    }

    public DCategory getCategory() {
        return category;
    }

    public void setCategory(DCategory category) {
        this.category = category;
    }

    public String getSecondCategoryIds() {
        return secondCategoryIds;
    }

    public void setSecondCategoryIds(String secondCategoryIds) {
        this.secondCategoryIds = secondCategoryIds;
    }

    public List<DCategory> getSecondaryCategories() {
        return secondaryCategories;
    }

    public void setSecondaryCategories(List<DCategory> secondaryCategories) {
        this.secondaryCategories = secondaryCategories;
    }

    public DPrintInfo getPrintInfo1() {
        return printInfo1;
    }

    public void setPrintInfo1(DPrintInfo printInfo1) {
        this.printInfo1 = printInfo1;
    }

    public DPrintInfo getPrintInfo2() {
        return printInfo2;
    }

    public void setPrintInfo2(DPrintInfo printInfo2) {
        this.printInfo2 = printInfo2;
    }

    public List<String> getTexts() {
        return texts;
    }

    public void setTexts(List<String> texts) {
        this.texts = texts;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public DBitmap getBitmap() {
        return bitmap;
    }

    public void setBitmap(DBitmap bitmap) {
        this.bitmap = bitmap;
    }

    public DSaleDate getSaleDate() {
        return saleDate;
    }

    public void setSaleDate(DSaleDate saleDate) {
        this.saleDate = saleDate;
    }

    public DSaleTime getSaleTime() {
        return saleTime;
    }

    public void setSaleTime(DSaleTime saleTime) {
        this.saleTime = saleTime;
    }

    public DPackDate getPackDate() {
        return packDate;
    }

    public void setPackDate(DPackDate packDate) {
        this.packDate = packDate;
    }

    public DPackTime getPackTime() {
        return packTime;
    }

    public void setPackTime(DPackTime packTime) {
        this.packTime = packTime;
    }

    public String getManualDiscount() {
        return manualDiscount;
    }

    /**
     * @description: 获取手动折扣方法
     **/
    public List<DManualDiscount> getManualdiscount() {
        return DPLUUtils.getDManualDiscount(manualDiscount);
    }

    public void setManualDiscount(String manualDiscount) {
        this.manualDiscount = manualDiscount;
    }

    public String getAutoDiscount1() {
        return autoDiscount1;
    }

    /**
     * @description: 获取自动折扣1
     **/
    public DAutoDiscount getAutodiscount1() {
        return DPLUUtils.getAutoDiscount(autoDiscount1);
    }

    public void setAutoDiscount1(String autoDiscount1) {
        this.autoDiscount1 = autoDiscount1;
    }

    public String getAutoDiscount2() {
        return autoDiscount2;
    }

    /**
     * @description: 获取自动折扣2
     **/
    public DAutoDiscount getAutodiscount2() {
        return DPLUUtils.getAutoDiscount(autoDiscount2);
    }

    public void setAutoDiscount2(String autoDiscount2) {
        this.autoDiscount2 = autoDiscount2;
    }

    public String getAutoDiscount3() {
        return autoDiscount3;
    }

    /**
     * @description: 获取自动折扣3
     **/
    public DAutoDiscount getAutodiscount3() {
        return DPLUUtils.getAutoDiscount(autoDiscount3);
    }

    public void setAutoDiscount3(String autoDiscount3) {
        this.autoDiscount3 = autoDiscount3;
    }

    public String getAutoDiscount4() {
        return autoDiscount4;
    }

    /**
     * @description: 获取自动折扣4
     **/
    public DAutoDiscount getAutodiscount4() {
        return DPLUUtils.getAutoDiscount(autoDiscount4);
    }

    public void setAutoDiscount4(String autoDiscount4) {
        this.autoDiscount4 = autoDiscount4;
    }
}
