package com.jhscale.common.model.device.plu;

import com.alibaba.fastjson.annotation.JSONField;
import com.jhscale.common.annotation.BigDecimalToDouble;
import com.jhscale.common.annotation.DoubleToBigDecimal;
import com.jhscale.common.model.device.plu.inner.DCategory;
import com.jhscale.common.model.device.plu.inner.DPricture;
import com.jhscale.common.model.device.plu.inner.DUnit;
import com.jhscale.common.model.device.plu.module.DPrice;
import com.jhscale.common.model.device.plu.module.DPrint;
import com.jhscale.common.model.device.plu.module.DSpecificationV2;
import com.jhscale.common.model.device.plu.module.DTime;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.*;

/**
 * @author lie_w
 * @title: DPLUV3
 * @projectName common
 * @description: DPLU升级版本
 * @date 2022/7/1519:08
 */
public class DPLUV3 implements DPLU<DPLUV3> {

    @ApiModelProperty(value = "PLU系统唯一编号", name = "code")
    private Long code;
    @ApiModelProperty(value = "商品编号（商户商品下不重复）", name = "no")
    private Integer no;
    @ApiModelProperty(value = "商品名称", name = "name")
    private String name;
    @ApiModelProperty(value = "图片", name = "pictures")
    private List<DPricture> pictures;
    @ApiModelProperty(value = "简写", name = "simple")
    private String simple;
    @ApiModelProperty(value = "商品上架状态", name = "state", example = "1-下架 2-正常，3-停售，4-缺货")
    private String state;
    @ApiModelProperty(value = "商品类型", name = "type", example = "0-普通商品（默认）,1-AI商品 (训练过的商品),2-AI待训练商品(用户创建商品)")
    private String type;
    @ApiModelProperty(value = "中央商品库编号", name = "centerCode")
    private String centerCode;
    @ApiModelProperty(value = "中央商品库名称", name = "centerName")
    private String centerName;
    @ApiModelProperty(value = "PLU序号", name = "sort")
    private Integer sort;
    @ApiModelProperty(value = "库存单位", name = "unit")
    private DUnit unit;

    @ApiModelProperty(value = "规格", name = "specifications")
    private List<DSpecificationV2> specifications;

    @ApiModelProperty(value = "货号", name = "number")
    private Integer number;
    @ApiModelProperty(value = "索引条码(主)", name = "indexBar")
    private String indexBar;
    @ApiModelProperty(value = "索引条码(辅助)", name = "indexBars")
    private List<String> indexBars;

    @ApiModelProperty(value = "成本", name = "costTrade")
    @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = DoubleToBigDecimal.class)
    private BigDecimal costTrade;
    @ApiModelProperty(value = "皮重", name = "trae")
    @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = DoubleToBigDecimal.class)
    private BigDecimal trae;
    @ApiModelProperty(value = "税率", name = "taxRate")
    @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = DoubleToBigDecimal.class)
    private BigDecimal taxRate;

    @ApiModelProperty(value = "主要类别", name = "category")
    private DCategory category;
    @ApiModelProperty(value = "次要类别编号", name = "secondCategoryIds")
    private String secondCategoryIds;
    @ApiModelProperty(value = "次要类别", name = "secondaryCategories")
    private List<DCategory> secondaryCategories;
    @ApiModelProperty(value = "快捷类别", name = "shortCategories")
    private List<DCategory> shortCategories;

    @ApiModelProperty(value = "打印信息", name = "print")
    private DPrint print;
    @ApiModelProperty(value = "其余打印信息（店铺打印信息）", name = "otherPrints")
    private Map<String, DPrint> otherPrints;
    @ApiModelProperty(value = "时间信息", name = "time")
    private DTime time;
    @ApiModelProperty(value = "其余时间信息（店铺时间信息）", name = "otherTime")
    private Map<String, DTime> otherTime;
    @ApiModelProperty(value = "价格信息", name = "price")
    private DPrice price;
    @ApiModelProperty(value = "其余价格信息（店铺价格）", name = "otherPrices")
    private Map<String, DPrice> otherPrices;
    @ApiModelProperty(value = "文本内容 条码秤最大长度8 收银秤另说", name = "texts")
    private List<String> texts;
    @ApiModelProperty(value = "其余文本内容（店铺文本）", name = "otherTexts")
    private Map<String, List<String>> otherTexts;

    @ApiModelProperty(value = "其余信息", name = "others")
    private Map<String, Object> others;

    public Long getCode() {
        return code;
    }

    public DPLUV3 setCode(Long code) {
        this.code = code;
        return this;
    }

    public Integer getNo() {
        return no;
    }

    /**
     * @description: 编号
     **/
    @Override
    public Integer no() {
        return this.no;
    }

    public DPLUV3 setNo(Integer no) {
        this.no = no;
        return this;
    }

    public String getName() {
        return name;
    }

    public DPLUV3 setName(String name) {
        this.name = name;
        return this;
    }

    public List<DPricture> getPictures() {
        return pictures;
    }

    public DPLUV3 setPictures(List<DPricture> pictures) {
        this.pictures = pictures;
        return this;
    }

    public String getSimple() {
        return simple;
    }

    public DPLUV3 setSimple(String simple) {
        this.simple = simple;
        return this;
    }

    public String getState() {
        return state;
    }

    public DPLUV3 setState(String state) {
        this.state = state;
        return this;
    }

    public String getType() {
        return type;
    }

    public DPLUV3 setType(String type) {
        this.type = type;
        return this;
    }

    public String getCenterCode() {
        return centerCode;
    }

    public DPLUV3 setCenterCode(String centerCode) {
        this.centerCode = centerCode;
        return this;
    }

    public String getCenterName() {
        return centerName;
    }

    public DPLUV3 setCenterName(String centerName) {
        this.centerName = centerName;
        return this;
    }

    public Integer getSort() {
        return sort;
    }

    public DPLUV3 setSort(Integer sort) {
        this.sort = sort;
        return this;
    }

    public DUnit getUnit() {
        return unit;
    }

    public DPLUV3 setUnit(DUnit unit) {
        this.unit = unit;
        return this;
    }

    public List<DSpecificationV2> getSpecifications() {
        return specifications;
    }

    public DPLUV3 setSpecifications(List<DSpecificationV2> specifications) {
        this.specifications = specifications;
        return this;
    }

    public Integer getNumber() {
        return number;
    }

    public DPLUV3 setNumber(Integer number) {
        this.number = number;
        return this;
    }

    public String getIndexBar() {
        return indexBar;
    }

    public DPLUV3 setIndexBar(String indexBar) {
        this.indexBar = indexBar;
        return this;
    }

    public List<String> getIndexBars() {
        return indexBars;
    }

    /**
     * @description: 设置条码
     **/
    public DPLUV3 addIndexBars(String... indexBars) {
        if (this.indexBars == null) this.indexBars = new ArrayList<>();
        if (indexBars != null && indexBars.length != 0) {
            this.indexBars.addAll(Arrays.asList(indexBars));
        }
        return this;
    }

    public DPLUV3 setIndexBars(List<String> indexBars) {
        this.indexBars = indexBars;
        return this;
    }

    public BigDecimal getCostTrade() {
        return costTrade;
    }

    public DPLUV3 setCostTrade(BigDecimal costTrade) {
        this.costTrade = costTrade;
        return this;
    }

    public BigDecimal getTrae() {
        return trae;
    }

    public DPLUV3 setTrae(BigDecimal trae) {
        this.trae = trae;
        return this;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public DPLUV3 setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
        return this;
    }

    public DCategory getCategory() {
        return category;
    }

    public DPLUV3 setCategory(DCategory category) {
        this.category = category;
        return this;
    }

    public String getSecondCategoryIds() {
        return secondCategoryIds;
    }

    public DPLUV3 setSecondCategoryIds(String secondCategoryIds) {
        this.secondCategoryIds = secondCategoryIds;
        return this;
    }

    public List<DCategory> getSecondaryCategories() {
        return secondaryCategories;
    }

    public DPLUV3 setSecondaryCategories(List<DCategory> secondaryCategories) {
        this.secondaryCategories = secondaryCategories;
        return this;
    }

    public List<DCategory> getShortCategories() {
        return shortCategories;
    }

    /**
     * @description: 添加快捷分类
     **/
    public DPLUV3 addShortCategories(DCategory... shortCategories) {
        if (this.shortCategories == null) this.shortCategories = new ArrayList<>();
        if (shortCategories != null && shortCategories.length != 0) {
            this.shortCategories.addAll(Arrays.asList(shortCategories));
        }
        return this;
    }

    public DPLUV3 setShortCategories(List<DCategory> shortCategories) {
        this.shortCategories = shortCategories;
        return this;
    }

    public DPrint getPrint() {
        return print;
    }

    public DPLUV3 setPrint(DPrint print) {
        this.print = print;
        return this;
    }

    public Map<String, DPrint> getOtherPrints() {
        return otherPrints;
    }

    public DPLUV3 setOtherPrints(Map<String, DPrint> otherPrints) {
        this.otherPrints = otherPrints;
        return this;
    }

    public DTime getTime() {
        return time;
    }

    public DPLUV3 setTime(DTime time) {
        this.time = time;
        return this;
    }

    public Map<String, DTime> getOtherTime() {
        return otherTime;
    }

    public DPLUV3 setOtherTime(Map<String, DTime> otherTime) {
        this.otherTime = otherTime;
        return this;
    }

    public DPrice getPrice() {
        return price;
    }

    public DPLUV3 setPrice(DPrice price) {
        this.price = price;
        return this;
    }

    public Map<String, DPrice> getOtherPrices() {
        return otherPrices;
    }

    public DPLUV3 setOtherPrices(Map<String, DPrice> otherPrices) {
        this.otherPrices = otherPrices;
        return this;
    }

    public List<String> getTexts() {
        return texts;
    }

    public DPLUV3 setTexts(List<String> texts) {
        this.texts = texts;
        return this;
    }

    public Map<String, List<String>> getOtherTexts() {
        return otherTexts;
    }

    public DPLUV3 setOtherTexts(Map<String, List<String>> otherTexts) {
        this.otherTexts = otherTexts;
        return this;
    }

    public Map<String, Object> getOthers() {
        return others;
    }

    public DPLUV3 setOthers(Map<String, Object> others) {
        this.others = others;
        return this;
    }

    /**
     * @description: 添加图片信息
     **/
    public DPLUV3 addPicture(DPricture... pictures) {
        if (this.pictures == null) this.pictures = new ArrayList<>();
        if (pictures != null && pictures.length != 0) {
            this.pictures.addAll(Arrays.asList(pictures));
        }
        return this;
    }

    /**
     * @description: 添加规格
     **/
    public DPLUV3 addSpecification(DSpecificationV2... specifications) {
        if (this.specifications == null) this.specifications = new ArrayList<>();
        if (specifications != null && specifications.length != 0) {
            this.specifications.addAll(Arrays.asList(specifications));
        }
        return this;
    }

    /**
     * @description: 添加其他打印信息
     **/
    public DPLUV3 putOtherPrint(String sign, DPrint print) {
        if (this.otherPrints == null) this.otherPrints = new HashMap<>();
        this.otherPrints.put(sign, print);
        return this;
    }

    /**
     * @description: 添加其他时间信息
     **/
    public DPLUV3 putOtherTime(String sign, DTime time) {
        if (this.otherTime == null) this.otherTime = new HashMap<>();
        this.otherTime.put(sign, time);
        return this;
    }

    /**
     * @description: 添加其他价格
     **/
    public DPLUV3 putOtherPrice(String sign, DPrice price) {
        if (this.otherPrices == null) this.otherPrices = new HashMap<>();
        this.otherPrices.put(sign, price);
        return this;
    }

    /**
     * @description: 添加文本
     **/
    public DPLUV3 addTexts(String... texts) {
        if (this.texts == null) this.texts = new ArrayList<>();
        if (texts != null)
            this.texts.addAll(Arrays.asList(texts));
        return this;
    }

    /**
     * @description: 添加其他文本
     **/
    @SuppressWarnings("all")
    public DPLUV3 putText(String sign, String... texts) {
        if (this.otherTexts == null) this.otherTexts = new HashMap<>();
        if (texts != null) {
            List<String> textList = this.otherTexts.get(sign);
            if (textList == null) {
                textList = new ArrayList<>();
                this.otherTexts.put(sign, textList);
            }
            textList.addAll(Arrays.asList(texts));
        }
        return this;
    }

    /**
     * @description: 添加其余信息
     **/
    public DPLUV3 putOther(String key, Object val) {
        if (this.others == null) this.others = new HashMap<>();
        this.others.put(key, val);
        return this;
    }
}
