package com.jhscale.common.model.device.plu;

import com.alibaba.fastjson.annotation.JSONField;
import com.jhscale.common.annotation.BigDecimalToDouble;
import com.jhscale.common.annotation.DataClass;
import com.jhscale.common.annotation.PublicField;
import com.jhscale.common.annotation.StringToBigDecimal;
import com.jhscale.common.content.JHContents;
import com.jhscale.common.model.device.DData;
import com.jhscale.common.model.device.UnitType;
import com.jhscale.common.model.device.plu.em.Restriction;
import com.jhscale.common.model.device.plu.inner.DAutoDiscountV2;
import com.jhscale.common.model.device.plu.inner.DManualDiscount;
import com.jhscale.common.model.device.plu.module.*;
import com.jhscale.common.model.device.plu.param.PLUPrepose;
import com.jhscale.common.utils.ByteUtils;
import com.jhscale.common.utils.PinyinUtils;
import com.jhscale.common.ysscale.UnitEnum;
import org.apache.commons.lang3.StringUtils;

import java.math.BigDecimal;
import java.util.*;

import static com.jhscale.common.model.device.DConstant.*;

/**
 * @author lie_w
 * @title: DPLUV3
 * @projectName common
 * @description: DPLU升级版本
 * @date 2022/7/1519:08
 */
@DataClass(mark = PLU, ask = true)
public class DPLUV5<T extends DPLUV5> extends DData<T> implements FDPLU<T> {

    // @ApiModelProperty(value = "货号", name = "itemCode")
    @PublicField(index = 2, type = INT)
    private Integer itemCode;

    // @ApiModelProperty(value = "索引条码(主)", name = "indexBar")
    @PublicField(index = 3, type = TXT)
    private String indexBar;

    // @ApiModelProperty(value = "单位(1-计重|2-计件|3-kg|4-g|5-ton|6-lb|7-500g|8-100g|9-1/4lb)", name = "unit")
    @PublicField(index = 4, type = INT)
    private Integer unit;


    // @ApiModelProperty(value = "单价|成本价|皮重", name = "field1", hidden = true)
    @PublicField(index = 5, type = M0)
    private String field1;


    // @ApiModelProperty(value = "打印信息", name = "print")
    @PublicField(index = 6, type = M1)
    private DPrintWithBitMapV1 print;

    // @ApiModelProperty(value = "分类（组）默认:9", name = "category")
    @PublicField(index = 7, type = INT, defaultVal = "9")
    private Integer category;

    // @ApiModelProperty(value = "PLU名称", name = "name")
    @PublicField(index = 8, type = TXT)
    private String name;

    // @ApiModelProperty(value = "文本内容 条码秤最大长度7 收银秤另说", name = "texts")
    @PublicField(index = 9, type = M2)
    private DTextV1 text;

    // @ApiModelProperty(value = "时间信息", name = "time")
    @PublicField(index = 10, type = M3)
    private DTimeV2 time;

    // @ApiModelProperty(value = "价格信息", name = "price")
    @PublicField(index = 11, type = M4)
    private DPriceV2 price;

    // @ApiModelProperty(value = "税率种类（0-无税|1-价内税|2-价内税，单价为税后价|3-价内税） 默认：0", name = "taxType")
    @PublicField(index = 12, type = INT, defaultVal = "0")
    private Integer taxType;

    // @ApiModelProperty(value = "税率%", name = "taxRate")
    @PublicField(index = 13, type = INT, defaultVal = "0")
    private Integer taxRate;

    // @ApiModelProperty(value = "sspVale_0", name = "sspVale_0")
    @PublicField(index = 14, type = INT, defaultVal = "0")
    private Integer sspVale_0;

    // @ApiModelProperty(value = "sspVale_0", name = "sspVale_1")
    @PublicField(index = 15, type = INT, defaultVal = "0")
    private Integer sspVale_1;

    // @ApiModelProperty(value = "sspVale_0", name = "sspVale_2")
    @PublicField(index = 16, type = INT, defaultVal = "0")
    private Integer sspVale_2;

    // @ApiModelProperty(value = "sspVale_0", name = "sspVale_3")
    @PublicField(index = 17, type = INT, defaultVal = "0")
    private Integer sspVale_3;

    // @ApiModelProperty(value = "特殊PLU应用。普通情况下，请保持为0", name = "stype")
    @PublicField(index = 18, type = TXT_M1, defaultVal = "0")
    private String stype;

    // @ApiModelProperty(value = "简写", name = "simple")
    @PublicField(index = 19, type = TXT)
    private String simple;


    // @ApiModelProperty(value = "标志|标志值|位图", name = "field2", hidden = true)
    @PublicField(index = 20, type = M5)
    private String field2;


    // @ApiModelProperty(value = "PLU图片", name = "pictures")
    @PublicField(index = 21, type = LST, list_type = TXT)
    private List<String> pictures;

    // @ApiModelProperty(value = "商品上架状态", name = "state", example = "0-未知，1-下架 2-正常，3-停售，4-缺货")
    @PublicField(index = 22, type = INT, defaultVal = "2")
    private Integer state;

    // @ApiModelProperty(value = "商品上架状态", name = "aiType")
    @PublicField(index = 23, type = M7)
    private DAIType aiType;

    // @ApiModelProperty(value = "索引条码(辅助)", name = "indexBars")
    @PublicField(index = 24, type = LST, list_type = TXT)
    private List<String> indexBars;

    @Deprecated
    // @ApiModelProperty(value = "其余打印信息（等级打印信息）", name = "otherPrints")
    // @PublicField(index = 25, type = MAP,
    //         map_key_type = INT, map_key_class = Integer.class,
    //         map_val_type = FML, map_val_class = DPrintWithBitMapV1.class)
    private Map<Integer, DPrintWithBitMapV1> otherPrints;

    @Deprecated
    // @ApiModelProperty(value = "其余时间信息（等级时间信息）", name = "otherTimes")
    // @PublicField(index = 26, type = MAP,
    //         map_key_type = INT, map_key_class = Integer.class,
    //         map_val_type = FML, map_val_class = DTimeV2.class)
    private Map<Integer, DTimeV2> otherTimes;

    // @ApiModelProperty(value = "其余价格信息（店铺价格）", name = "otherPrices")
    @PublicField(index = 27, type = M6/*,
            map_key_type = INT, map_key_class = Integer.class,
            map_val_type = FML, map_val_class = DPriceV2.class*/)
    private Map<Integer, DPriceV2> otherPrices;

    @Deprecated
    // @ApiModelProperty(value = "其余文本内容（等级文本）", name = "otherTexts")
    // @PublicField(index = 28, type = MAP,
    //         map_key_type = INT, map_key_class = Integer.class,
    //         map_val_type = FML, map_val_class = DTextV1.class)
    private Map<Integer, DTextV1> otherTexts;

    // @ApiModelProperty(value = "特殊业务: 自定义量词(当unit=2时有意义) 如果空，代表使用语言本身的计件单位", name = "unitText")
    private String unitText;

    // @ApiModelProperty(value = "成本", name = "costTrade")
    @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = StringToBigDecimal.class)
    private BigDecimal costTrade;

    // @ApiModelProperty(value = "特殊业务: 计件取重(当unit=2时有意义)", name = "saveAsWeight")
    private Integer saveAsWeight;       //0 for Disable, 1 for Enable

    // @ApiModelProperty(value = "皮重(当unit!=2时有意义)", name = "tare")
    @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = StringToBigDecimal.class)
    private BigDecimal tare;

    // @ApiModelProperty(value = "特殊业务: 百分比皮重", name = "percentTare")
    @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = StringToBigDecimal.class)
    private BigDecimal percentTare;

    // @ApiModelProperty(value = "特殊业务: 固定重量(当unit!=2时有意义，当本业务启用, percentTare/tare均无用)", name = "fixedWeight")
    @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = StringToBigDecimal.class)
    private BigDecimal fixedWeight;

    /**
     * @description: 公开协议 组包 不使用反射
     **/
    @Override
    public StringBuilder Public_Package_No_Reflex() {
        StringBuilder builder = super.Public_Package_No_Reflex()
                .append(this.to_append(PLU))
                .append(this.to_append(this.no()))
                .append(this.to_append(this.getItemCode()))
                .append(this.to_append(this.getIndexBar()))
                .append(this.to_append(this.getUnit(), UnitEnum.计件.val()));

        DPriceV2 price = this.getPrice();
        price = Objects.nonNull(price) ? price : new DPriceV2();

        builder.append(this.to_append(price.price()))
                .append(this.to_append(Objects.nonNull(this.getCostTrade()) ? this.getCostTrade() : BigDecimal.ZERO))
                .append(this.to_append(this.getTare()));

        DPrintWithBitMapV1 print = this.getPrint();
        print = Objects.nonNull(print) ? print : new DPrintWithBitMapV1();

        builder.append(this.to_append(print.type1()))
                .append(this.to_append(print.barcode1()))
                .append(this.to_append(print.sign1()))
                .append(this.to_append(print.type2()))
                .append(this.to_append(print.barcode2()))
                .append(this.to_append(print.sign2()));

        builder.append(this.to_append(this.getCategory(), DEFAULT_CLASS))
                .append(this.to_append_text(this.getName()));

        DTextV1 text = this.getText();
        text = Objects.nonNull(text) ? text : new DTextV1();

        builder.append(this.to_append_list(text.getTexts(), 7));

        DTimeV2 time = this.getTime();
        time = Objects.nonNull(time) ? time : new DTimeV2();

        builder.append(this.to_append(time.saleDatePS()))
                .append(this.to_append(time.saleTimePS()))
                .append(this.to_append(time.packDatePS()))
                .append(this.to_append(time.packTimePS()))
                .append(this.to_append(time.useDatePS()))
                .append(this.to_append(time.saleDatePC()))
                .append(this.to_append(time.saleTimePC()))
                .append(this.to_append(time.packDatePC()))
                .append(this.to_append(time.packTimePC()))
                .append(this.to_append(time.useDatePC()));

        DManualDiscount upperManualDiscount = price._manualDiscount(Restriction.上限.getRestriction());
        DManualDiscount lowerManualDiscount = price._manualDiscount(Restriction.下限.getRestriction());

        builder.append(this.to_append(upperManualDiscount != null ? upperManualDiscount.getType() : ""))
                .append(this.to_append(lowerManualDiscount != null ? lowerManualDiscount.getType() : ""))
                .append(this.to_append_bigDecimal(upperManualDiscount != null ? upperManualDiscount.getDiscount() : null))
                .append(this.to_append_bigDecimal(lowerManualDiscount != null ? lowerManualDiscount.getDiscount() : null));

        for (int i = 0; i < 4; i++) {
            DAutoDiscountV2 autoDiscount = price._autoDiscount(i);
            if (autoDiscount != null) {
                builder.append(this.to_append(autoDiscount.type()))
                        .append(this.to_append(autoDiscount.date()))
                        .append(this.to_append(autoDiscount.lower()))
                        .append(this.to_append(autoDiscount.upper()))
                        .append(this.to_append(autoDiscount.discount()));
            } else {
                builder.append(this.to_append_length(5));
            }
        }

        builder.append(this.to_append(this.getTaxType(), DEFAULT_I0))
                .append(this.to_append(this.getTaxRate(), DEFAULT_I0))
                .append(this.to_append(this.getSspVale_0()))
                .append(this.to_append(this.getSspVale_1()))
                .append(this.to_append(this.getSspVale_2()))
                .append(this.to_append(this.getSspVale_3()))
                .append(this.to_append(this.getStype(), DEFAULT_V0))
                .append(this.to_append(this.getSimple()));

        PLUPrepose prepose = (PLUPrepose) this.prepose();
        builder.append(this.to_append(prepose.getSign()))
                .append(this.to_append(prepose.getSignVal()))
                .append(this.to_append(print.bitmap()))
                .append(this.to_append_list(this.getPictures()))
                .append(this.to_append(this.getState(), PLU_State_NORMAL));

        DAIType aiType = this.getAiType();
        if (aiType != null) {
            builder.append(this.to_append(aiType.Public_Package_No_Reflex()));
        } else {
            builder.append(this.to_append(new DAIType().type()));
        }

        builder.append(this.to_append_list(this.getIndexBars()))
                .append(this.to_append(this.to_otherPrices(this.getOtherPrices())))
                .append(PUBLIC_LINE_SPLIT);
        return builder;
    }

    /**
     * @param all_fields
     * @param
     * @description: 直接赋值
     */
    @Override
    public T Public_UnPackage_No_Reflex(String[] all_fields) {
        try {
            this.setNo(this.toInteger(all_fields, 0))
                    .setItemCode(this.toInteger(all_fields, 1))
                    .setIndexBar(this.toString(all_fields, 2))
                    .setUnit(this.toInteger(all_fields, 3, UnitEnum.计件.val()));

            DPriceV2 price = new DPriceV2()
                    .setPrice(this.toBigDecimal(all_fields, 4));

            try {
                DManualDiscount upperManualDiscount = new DManualDiscount.DUpperManualDiscount()
                        .setType(this.toIntegerDefault(all_fields, 32))
                        .setDiscount(this.toBigDecimal(all_fields, 34));
                if (upperManualDiscount != null)
                    price.addManualDiscounts(upperManualDiscount);
            } catch (Exception e) {
            }
            try {
                DManualDiscount lowerManualDiscount = new DManualDiscount.DLowerManualDiscount()
                        .setType(this.toIntegerDefault(all_fields, 33))
                        .setDiscount(this.toBigDecimal(all_fields, 35));
                if (lowerManualDiscount != null)
                    price.addManualDiscounts(lowerManualDiscount);
            } catch (Exception e) {
            }
            DAutoDiscountV2 autoDiscount0 = null;
            try {
                autoDiscount0 = new DAutoDiscountV2(
                        this.toIntegerDefault(all_fields, 36),
                        this.toIntegerDefault(all_fields, 37),
                        this.toBigDecimal(all_fields, 38),
                        this.toBigDecimal(all_fields, 39),
                        this.toBigDecimal(all_fields, 40)
                );
            } catch (Exception e) {
            }
            price.addAutoDiscounts(0, autoDiscount0);
            DAutoDiscountV2 autoDiscount1 = null;
            try {
                autoDiscount1 = new DAutoDiscountV2(
                        this.toIntegerDefault(all_fields, 41),
                        this.toIntegerDefault(all_fields, 42),
                        this.toBigDecimal(all_fields, 43),
                        this.toBigDecimal(all_fields, 44),
                        this.toBigDecimal(all_fields, 45)
                );
            } catch (Exception e) {
            }
            price.addAutoDiscounts(1, autoDiscount1);
            DAutoDiscountV2 autoDiscount2 = null;
            try {
                autoDiscount2 = new DAutoDiscountV2(
                        this.toIntegerDefault(all_fields, 46),
                        this.toIntegerDefault(all_fields, 47),
                        this.toBigDecimal(all_fields, 48),
                        this.toBigDecimal(all_fields, 49),
                        this.toBigDecimal(all_fields, 50)
                );
            } catch (Exception e) {
            }
            price.addAutoDiscounts(2, autoDiscount2);
            DAutoDiscountV2 autoDiscount3 = null;
            try {
                autoDiscount3 = new DAutoDiscountV2(
                        this.toIntegerDefault(all_fields, 51),
                        this.toIntegerDefault(all_fields, 52),
                        this.toBigDecimal(all_fields, 53),
                        this.toBigDecimal(all_fields, 54),
                        this.toBigDecimal(all_fields, 55)
                );
            } catch (Exception e) {
            }
            price.addAutoDiscounts(3, autoDiscount3);
            this.setPrice(price);

            this.setCostTrade(this.toBigDecimal(all_fields, 5))
                    .setTare(this.toBigDecimal(all_fields, 6));

            DPrintWithBitMapV1 print = new DPrintWithBitMapV1()
                    .setType1(this.toInteger(all_fields, 7))
                    .setBarcode1(this.toInteger(all_fields, 8))
                    .setSign1(this.toInteger(all_fields, 9))
                    .setType2(this.toInteger(all_fields, 10))
                    .setBarcode2(this.toInteger(all_fields, 11))
                    .setSign2(this.toInteger(all_fields, 12));
            this.setPrint(print);

            this.setCategory(this.toInteger(all_fields, 13, DEFAULT_CLASS))
                    .setName(this.toText(all_fields, 14));

            DTextV1 text = new DTextV1()
                    .addTexts(this.toText(all_fields, 15))
                    .addTexts(this.toText(all_fields, 16))
                    .addTexts(this.toText(all_fields, 17))
                    .addTexts(this.toText(all_fields, 18))
                    .addTexts(this.toText(all_fields, 19))
                    .addTexts(this.toText(all_fields, 20));
            this.setText(text);

            DTimeV2 time = new DTimeV2()
                    .setSaleDatePS(this.toInteger(all_fields, 22))
                    .setSaleTimePS(this.toInteger(all_fields, 23))
                    .setPackDatePS(this.toInteger(all_fields, 24))
                    .setPackTimePS(this.toInteger(all_fields, 25))
                    .setUseDatePS(this.toInteger(all_fields, 26))
                    .setSaleDatePC(this.toInteger(all_fields, 27))
                    .setSaleTimePC(this.toInteger(all_fields, 28))
                    .setPackDatePC(this.toInteger(all_fields, 29))
                    .setPackTimePC(this.toInteger(all_fields, 30))
                    .setUseDatePC(this.toInteger(all_fields, 31));
            this.setTime(time);

            this.setTaxType(this.toInteger(all_fields, 56, DEFAULT_I0))
                    .setTaxRate(this.toInteger(all_fields, 57, DEFAULT_I0))
                    .setSspVale_0(this.toInteger(all_fields, 58))
                    .setSspVale_1(this.toInteger(all_fields, 59))
                    .setSspVale_2(this.toInteger(all_fields, 60))
                    .setSspVale_3(this.toInteger(all_fields, 61))
                    .setStype(this.toString(all_fields, 62, DEFAULT_V0))
                    .setSimple(this.toString(all_fields, 63));

            String stype = ByteUtils.appendFill(Integer.toBinaryString(Integer.parseInt(all_fields[64])), 4);
            if (UnitType.计件.equals(UnitEnum.unit(this.getUnit()).getType())) {
                if (stype.charAt(3) == '1') {
                    this.setUnitText(this.toText(all_fields, 21));
                } else {
                    text.addTexts(this.toText(all_fields, 21));
                }
                this.setSaveAsWeight(stype.charAt(2) == '1' ? SAVE_WEIGHT_ENABLE : SAVE_WEIGHT_DISABLE);
            } else {
                text.addTexts(this.toText(all_fields, 21));
                if (stype.charAt(2) == '1')
                    this.setFixedWeight(this.toBigDecimal(all_fields, 65));
                if (stype.charAt(3) == '1')
                    this.setPercentTare(this.toBigDecimal(all_fields, 65));
            }

            print.setBitmap(this.toInteger(all_fields, 66));

            this.setPictures(this.toStringList(all_fields, 67))
                    .setState(this.toInteger(all_fields, 68, PLU_State_NORMAL));

            String ai_info = this.toString(all_fields, 69);
            if (StringUtils.isNotBlank(ai_info)) {
                DAIType daiType = (DAIType) new DAIType().Public_UnPackage_No_Reflex(ai_info);
                // DAIType daiType = new DAIType();
                // String[] ai_info_array = ai_info.split(PUBLIC_FIELD_SPLIT_1);
                // daiType.setType(this.toInteger(ai_info_array, 0));
                // List<String> list = this.toStringList(ai_info_array, 1);
                // if (list != null && !list.isEmpty()) {
                //     for (String model : list) {
                //         daiType.addModels(new DAIModel(model));
                //     }
                // }
                this.setAiType(daiType);
            }

            this.setIndexBars(this.toStringList(all_fields, 70));

            String otherPrices = this.toString(all_fields, 71);
            if (StringUtils.isNotBlank(otherPrices)) {
                String[] other_prices = otherPrices.split(DP_SPLIT2_1);
                for (String other_price : other_prices) {
                    if (StringUtils.isNotBlank(other_price)) {
                        String[] other_price_part = other_price.split(DP_SPLIT1);
                        this.toOtherPrice(other_price_part);
                    }
                }
            }
        } catch (ArrayIndexOutOfBoundsException e) {
        } catch (Exception e) {
            e.printStackTrace();
        }
        return (T) this;
    }


    /*******************************默认值Get 方法*************************************/

    public Integer itemCode() {
        return Objects.nonNull(this.itemCode) ? this.itemCode : this.no();
    }

    public Integer unit() {
        return Objects.nonNull(this.unit) ? this.unit : BigDecimal.ONE.intValue();
    }

    public BigDecimal tare() {
        return Objects.nonNull(this.tare) ? this.tare : BigDecimal.ZERO;
    }

    public BigDecimal percentTare() {
        return Objects.nonNull(this.percentTare) ? this.percentTare : BigDecimal.ZERO;
    }

    public BigDecimal fixedWeight() {
        return Objects.nonNull(this.fixedWeight) ? this.fixedWeight : BigDecimal.ZERO;
    }

    public BigDecimal costTrade() {
        return Objects.nonNull(this.costTrade) ? this.costTrade : BigDecimal.ZERO;
    }

    public Integer taxType() {
        return Objects.nonNull(this.taxType) ? this.taxType : BigDecimal.ZERO.intValue();
    }

    public Integer taxRate() {
        return Objects.nonNull(this.taxRate) ? this.taxRate : BigDecimal.ZERO.intValue();
    }

    public Integer state() {
        return Objects.nonNull(this.state) ? this.state : BigDecimal.ZERO.intValue();
    }

    public Integer category() {
        return Objects.nonNull(this.category) ? this.category : JHContents.DEFAULT_CATEGORY;
    }

    public Integer _saveAsWeight() {
        return Objects.nonNull(this.saveAsWeight) ? this.saveAsWeight : BigDecimal.ZERO.intValue();
    }

    /*******************************默认值Get 方法*************************************/

    public Integer getItemCode() {
        return itemCode;
    }

    public T setItemCode(Integer itemCode) {
        this.itemCode = itemCode;
        return (T) this;
    }

    public String getIndexBar() {
        return indexBar;
    }

    public T setIndexBar(String indexBar) {
        this.indexBar = indexBar;
        return (T) this;
    }

    public Integer getUnit() {
        return unit;
    }

    public T setUnit(Integer unit) {
        this.unit = unit;
        return (T) this;
    }

    public DPrintWithBitMapV1 getPrint() {
        return print;
    }

    public DPrintWithBitMapV1 print() {
        return Objects.nonNull(this.print) ? this.print : new DPrintWithBitMapV1();
    }

    public T setPrint(DPrintWithBitMapV1 print) {
        this.print = print;
        return (T) this;
    }

    public Integer getCategory() {
        return category;
    }

    public T setCategory(Integer category) {
        this.category = category;
        return (T) this;
    }

    public String getName() {
        return name;
    }

    public T setName(String name) {
        this.name = name;
        return (T) this;
    }

    public DTextV1 getText() {
        return text;
    }

    public T setText(DTextV1 text) {
        this.text = text;
        return (T) this;
    }

    public DTimeV2 getTime() {
        return time;
    }

    public DTimeV2 time() {
        return Objects.nonNull(this.time) ? this.time : new DTimeV2();
    }

    public T setTime(DTimeV2 time) {
        this.time = time;
        return (T) this;
    }

    public DPriceV2 getPrice() {
        return price;
    }

    public T setPrice(DPriceV2 price) {
        this.price = price;
        return (T) this;
    }

    public Integer getTaxType() {
        return taxType;
    }

    public T setTaxType(Integer taxType) {
        this.taxType = taxType;
        return (T) this;
    }

    public Integer getTaxRate() {
        return taxRate;
    }

    public T setTaxRate(Integer taxRate) {
        this.taxRate = taxRate;
        return (T) this;
    }

    public Integer getSspVale_0() {
        return sspVale_0;
    }

    public T setSspVale_0(Integer sspVale_0) {
        this.sspVale_0 = sspVale_0;
        return (T) this;
    }

    public Integer getSspVale_1() {
        return sspVale_1;
    }

    public T setSspVale_1(Integer sspVale_1) {
        this.sspVale_1 = sspVale_1;
        return (T) this;
    }

    public Integer getSspVale_2() {
        return sspVale_2;
    }

    public T setSspVale_2(Integer sspVale_2) {
        this.sspVale_2 = sspVale_2;
        return (T) this;
    }

    public Integer getSspVale_3() {
        return sspVale_3;
    }

    public T setSspVale_3(Integer sspVale_3) {
        this.sspVale_3 = sspVale_3;
        return (T) this;
    }

    public String getStype() {
        return stype;
    }

    public T setStype(String stype) {
        this.stype = stype;
        return (T) this;
    }

    public String getSimple() {
        return simple;
    }

    public T setSimple(String simple) {
        this.simple = simple;
        return (T) this;
    }

    public List<String> getPictures() {
        return pictures;
    }

    public T setPictures(List<String> pictures) {
        this.pictures = pictures;
        return (T) this;
    }

    public Integer getState() {
        return state;
    }

    public T setState(Integer state) {
        this.state = state;
        return (T) this;
    }

    public DAIType getAiType() {
        return aiType;
    }

    public T setAiType(DAIType aiType) {
        this.aiType = aiType;
        return (T) this;
    }

    public List<String> getIndexBars() {
        return indexBars;
    }

    public T setIndexBars(List<String> indexBars) {
        this.indexBars = indexBars;
        return (T) this;
    }

    public String getUnitText() {
        return unitText;
    }

    public T setUnitText(String unitText) {
        this.unitText = unitText;
        return (T) this;
    }

    @Deprecated
    private Map<Integer, DPrintWithBitMapV1> getOtherPrints() {
        return otherPrints;
    }

    @Deprecated
    private T setOtherPrints(Map<Integer, DPrintWithBitMapV1> otherPrints) {
        this.otherPrints = otherPrints;
        return (T) this;
    }

    @Deprecated
    private Map<Integer, DTimeV2> getOtherTimes() {
        return otherTimes;
    }

    @Deprecated
    private T setOtherTimes(Map<Integer, DTimeV2> otherTimes) {
        this.otherTimes = otherTimes;
        return (T) this;
    }

    public Map<Integer, DPriceV2> getOtherPrices() {
        return otherPrices;
    }

    public T setOtherPrices(Map<Integer, DPriceV2> otherPrices) {
        this.otherPrices = otherPrices;
        return (T) this;
    }

    @Deprecated
    private Map<Integer, DTextV1> getOtherTexts() {
        return otherTexts;
    }

    @Deprecated
    private T setOtherTexts(Map<Integer, DTextV1> otherTexts) {
        this.otherTexts = otherTexts;
        return (T) this;
    }

    public BigDecimal getCostTrade() {
        return costTrade;
    }

    public T setCostTrade(BigDecimal costTrade) {
        this.costTrade = costTrade;
        return (T) this;
    }

    public Integer getSaveAsWeight() {
        return saveAsWeight;
    }

    public T setSaveAsWeight(Integer saveAsWeight) {
        this.saveAsWeight = saveAsWeight;
        return (T) this;
    }

    public BigDecimal getTare() {
        return tare;
    }

    public T setTare(BigDecimal tare) {
        this.tare = tare;
        return (T) this;
    }

    public BigDecimal getPercentTare() {
        return percentTare;
    }

    public T setPercentTare(BigDecimal percentTare) {
        this.percentTare = percentTare;
        return (T) this;
    }

    public BigDecimal getFixedWeight() {
        return fixedWeight;
    }

    public T setFixedWeight(BigDecimal fixedWeight) {
        this.fixedWeight = fixedWeight;
        return (T) this;
    }

    /**
     * @description: 设置条码
     **/
    public T addIndexBars(String... indexBars) {
        if (this.indexBars == null) this.indexBars = new ArrayList<>();
        if (indexBars != null && indexBars.length != 0) {
            this.indexBars.addAll(Arrays.asList(indexBars));
        }
        return (T) this;
    }

    /**
     * @description: 添加其他打印信息
     **/
    @Deprecated
    private T putOtherPrint(Integer level, DPrintWithBitMapV1 print) {
        if (this.otherPrints == null) this.otherPrints = new HashMap<>();
        this.otherPrints.put(level, print);
        return (T) this;
    }

    /**
     * @description: 打印信息获取
     **/
    @Deprecated
    private DPrintWithBitMapV1 print(Integer level) {
        DPrintWithBitMapV1 print = null;
        if (Objects.nonNull(level) && this.otherPrints != null)
            print = this.otherPrints.get(level);
        return Objects.nonNull(print) ? print : (Objects.nonNull(this.print) ? this.print : new DPrintWithBitMapV1());
    }

    /**
     * @description: 添加其他时间信息
     **/
    @Deprecated
    private T putOtherTimes(Integer level, DTimeV2 time) {
        if (this.otherTimes == null) this.otherTimes = new HashMap<>();
        this.otherTimes.put(level, time);
        return (T) this;
    }

    /**
     * @description: 时间信息获取
     **/
    @Deprecated
    private DTimeV2 time(Integer level) {
        DTimeV2 time = null;
        if (Objects.nonNull(level) && this.otherTimes != null)
            time = this.otherTimes.get(level);
        return Objects.nonNull(time) ? time : (Objects.nonNull(this.time) ? this.time : new DTimeV2());
    }

    /**
     * @description: 添加其他价格
     **/
    public T putOtherPrice(Integer level, DPriceV2 price) {
        if (this.otherPrices == null) this.otherPrices = new HashMap<>();
        this.otherPrices.put(level, price);
        return (T) this;
    }

    /**
     * @description: 价格信息获取
     **/
    public DPriceV2 price(Integer level) {
        DPriceV2 price = null;
        if (Objects.nonNull(level) && this.otherPrices != null)
            price = this.otherPrices.get(level);
        return Objects.nonNull(price) ? price : (Objects.nonNull(this.price) ? this.price : new DPriceV2());
    }

    /**
     * @description: 添加其他文本
     **/
    @Deprecated
    private T putText(Integer level, DTextV1 texts) {
        if (this.otherTexts == null) this.otherTexts = new HashMap<>();
        this.otherTexts.put(level, texts);
        return (T) this;
    }

    /**
     * @description: 文本信息获取
     **/
    @Deprecated
    private DTextV1 text(Integer level) {
        DTextV1 text = null;
        if (Objects.nonNull(level) && this.otherTexts != null)
            text = this.otherTexts.get(level);
        return Objects.nonNull(text) ? text : this.text;
    }

    /**
     * @description: 添加拼音简写
     **/
    public T addPinyinSimple() {
        if (StringUtils.isBlank(this.simple) && StringUtils.isNotBlank(this.name)) {
            this.simple = PinyinUtils.getPinYinHeadCharNoMark(this.name).toUpperCase();
        }
        return (T) this;
    }
}
