package com.jhscale.common.model.device.plu;

import com.jhscale.common.annotation.DataClass;
import com.jhscale.common.model.device.UnitType;
import com.jhscale.common.model.device._inner.PublicUnPackage;
import com.jhscale.common.model.device._inner.PublicUnPackageArray;
import com.jhscale.common.model.device._inner.PublicUnPackageObject;
import com.jhscale.common.model.device.plu.em.Restriction;
import com.jhscale.common.model.device.plu.inner.DAutoDiscountV2;
import com.jhscale.common.model.device.plu.inner.DManualDiscount;
import com.jhscale.common.model.device.plu.module.*;
import com.jhscale.common.model.device.plu.param.PLUPrepose;
import com.jhscale.common.model.device.plu.param.Prepose;
import com.jhscale.common.model.inter.DataJSONModel;
import com.jhscale.common.utils.ArrayUtils;
import com.jhscale.common.utils.BigDecimalUtils;
import com.jhscale.common.utils.ByteUtils;
import com.jhscale.common.ysscale.UnitEnum;
import org.apache.commons.lang3.StringUtils;

import java.math.BigDecimal;
import java.util.*;

import static com.jhscale.common.model.device.DConstant.*;

/**
 * @author lie_w
 * @title: DPLU
 * @projectName common
 * @description: TODO
 * @date 2022/7/1518:56
 */
public interface FDPLU<T extends FDPLU> extends DataJSONModel<T> {

    /**
     * @description: 对象前置对象处理
     **/
    @Override
    default Prepose prepose() {
        int sign = 0;
        String signVal = "";
        if (UnitType.计件.equals(UnitEnum.unit(this.getUnit()).getType())) {
            if (StringUtils.isNotBlank(this.getUnitText())) {
                sign += 0x01;
                DTextV1 text = this.getText();
                if (text == null) {
                    text = new DTextV1();
                    this.setText(text);
                }

                List texts = ArrayUtils.addIndex(text.getTexts(), 6, this.getUnitText());
                text.setTexts(texts);
            } else if (this.getSaveAsWeight() != null && this.saveAsWeight()) {
                sign += 0x02;
            }
        } else {
            if (Objects.nonNull(this.getFixedWeight())) {
                sign += 0x02;
                signVal = BigDecimalUtils.bigDecimalToString(this.getFixedWeight());
                this.setTare(null);
            } else if (Objects.nonNull(this.getPercentTare())) {
                sign += 0x04;
                signVal = BigDecimalUtils.bigDecimalToString(this.getPercentTare());
            }
        }
        return new PLUPrepose(sign, signVal);
    }

    /**
     * @param serial
     * @description: 默认组装方法1
     */
    @Override
    default String package_method(int serial) {
        DataClass annotation = this.getClass().getAnnotation(DataClass.class);
        StringBuffer buffer = new StringBuffer();
        try {
            switch (serial) {
                case 0:
                    DPriceV2 price_0 = this.getPrice();
                    BigDecimal price_f = Objects.nonNull(price_0) ? price_0.price() : BigDecimal.ZERO;
                    buffer.append(BigDecimalUtils.bigDecimalToString(price_f))
                            .append(annotation.separator())
                            .append(BigDecimalUtils.bigDecimalToString(this.costTrade()))
                            .append(annotation.separator())
                            .append(BigDecimalUtils.bigDecimalToString(this.tare()));
                    break;
                case 1:
                    DPrintWithBitMapV1 print = this.getPrint();
                    buffer.append(Objects.nonNull(print) ? print.type1() : "")
                            .append(annotation.separator())
                            .append(Objects.nonNull(print) ? print.barcode1() : "")
                            .append(annotation.separator())
                            .append(Objects.nonNull(print) ? print.sign1() : "")
                            .append(annotation.separator())
                            .append(Objects.nonNull(print) ? print.type2() : "")
                            .append(annotation.separator())
                            .append(Objects.nonNull(print) ? print.barcode2() : "")
                            .append(annotation.separator())
                            .append(Objects.nonNull(print) ? print.sign2() : "");
                    break;
                case 2:
                    DTextV1 text = this.getText();
                    if (text != null && text.getTexts() != null) {
                        for (int i = 0; i < 7; i++) {
                            if (i < text.getTexts().size()
                                    && StringUtils.isNotBlank(text.getTexts().get(i))) {
                                buffer.append(ByteUtils.tryParseToString(ByteUtils.strMaxLength(text.getTexts().get(i), 128)));
                            }
                            if (i != 6) buffer.append(annotation.separator());
                        }
                    } else {
                        for (int i = 0; i < 7; i++) {
                            buffer.append("")
                                    .append(i != 6 ? annotation.separator() : "");
                        }
                    }
                    break;
                case 3:
                    DTimeV2 time = this.getTime();
                    time = time == null ? new DTimeV2() : time;
                    buffer.append(time.Public_Package(annotation.separator()));
                    break;
                case 4:
                    DPriceV2 price_4 = this.getPrice();
                    price_4 = price_4 == null ? new DPriceV2() : price_4;

                    List<DManualDiscount> manualDiscounts = price_4.getManualDiscounts();
                    if (manualDiscounts != null && !manualDiscounts.isEmpty()) {
                        DManualDiscount upperManualDiscount = price_4._manualDiscount(Restriction.上限.getRestriction());
                        DManualDiscount lowerManualDiscount = price_4._manualDiscount(Restriction.下限.getRestriction());
                        buffer.append((upperManualDiscount == null || upperManualDiscount.getType() == null) ? "" : upperManualDiscount.getType())
                                .append(annotation.separator())
                                .append((lowerManualDiscount == null || lowerManualDiscount.getType() == null) ? "" : lowerManualDiscount.getType())
                                .append(annotation.separator())
                                .append((upperManualDiscount == null || upperManualDiscount.getDiscount() == null) ? "" : BigDecimalUtils.bigDecimalToString(upperManualDiscount.getDiscount()))
                                .append(annotation.separator())
                                .append((lowerManualDiscount == null || lowerManualDiscount.getDiscount() == null) ? "" : BigDecimalUtils.bigDecimalToString(lowerManualDiscount.getDiscount()))
                                .append(annotation.separator());
                    } else {
                        for (int i = 0; i < 4; i++) {
                            buffer.append(annotation.separator());
                        }
                    }

                    for (int i = 0; i < 4; i++) {
                        DAutoDiscountV2 autoDiscount = price_4._autoDiscount(i);
                        if (autoDiscount != null) {
                            buffer.append(autoDiscount.Public_Package(annotation.separator()));
                        } else {
                            for (int j = 0; j < 4; j++) {
                                buffer.append(annotation.separator());
                            }
                        }
                        if (i != 3) buffer.append(annotation.separator());
                    }

//                    List<DAutoDiscountV2> autoDiscounts = price_4.getAutoDiscounts();
//                    if (autoDiscounts != null && !autoDiscounts.isEmpty()) {
//                        StringBuffer buffer_autoDiscounts = new StringBuffer();
//                        for (int i = 0; i < 4; i++) {
//                            if (i < autoDiscounts.size()) {
//                                buffer_autoDiscounts.append(autoDiscounts.get(i).Public_Package(annotation.separator()))
//                                        .append(annotation.separator());
//                            } else {
//                                for (int j = 0; j < 5; j++) {
//                                    buffer_autoDiscounts.append(annotation.separator());
//                                }
//                            }
//                        }
//                        buffer.append(buffer_autoDiscounts.substring(0, buffer_autoDiscounts.length() - 1));
//                    } else {
//                        for (int i = 0; i < 19; i++) {
//                            buffer.append(annotation.separator());
//                        }
//                    }
                    break;
                case 5:
                    DPrintWithBitMapV1 print_b = this.getPrint();
                    PLUPrepose prepose = (PLUPrepose) this.prepose();
                    buffer.append(prepose.getSign())
                            .append(annotation.separator())
                            .append(prepose.getSignVal())
                            .append(annotation.separator())
                            .append(print_b != null ? print_b.bitmap() : "");
                    break;
                case 6:
                    buffer.append(this.to_otherPrices(this.getOtherPrices()));
                    break;
                case 7:
                    buffer.append(this.getAiType().Public_Package_No_Reflex());
                    break;
            }
        } catch (Exception e) {
        }
        return buffer.toString();
    }

    /**
     * @param contents
     * @param serial
     * @description: 默认拆解方法1
     */
    @Override
    default PublicUnPackage un_package_method(String[] contents, int serial) {
        PublicUnPackage unPackage = new PublicUnPackage(contents);
        try {
            switch (serial) {
                case 0:
                    unPackage = this.contents_copyOfRange(unPackage.getSurplusContents(), 3);
                    String[] contents_0 = ((PublicUnPackageArray) unPackage).getContents();
                    BigDecimal price_f = BigDecimalUtils.stringToBigDecimal(contents_0[0]);
                    DPriceV2 price_0 = this.getPrice();
                    if (price_0 == null) {
                        price_0 = new DPriceV2();
                        this.setPrice(price_0);
                    }
                    price_0.setPrice(price_f != null ? price_f : BigDecimal.ZERO);
                    this.setCostTrade(BigDecimalUtils.stringToBigDecimal(contents_0[1]));
                    this.setTare(BigDecimalUtils.stringToBigDecimal(contents_0[2]));
                    break;
                case 1:
                    unPackage = this.contents_copyOfRange(unPackage.getSurplusContents(), 6);
                    String[] contents_1 = ((PublicUnPackageArray) unPackage).getContents();
                    DPrintWithBitMapV1 print = this.getPrint();
                    if (print == null) {
                        print = new DPrintWithBitMapV1();
                        this.setPrint(print);
                    }
                    print.setType1(StringUtils.isNotBlank(contents_1[0]) ? Integer.parseInt(contents_1[0]) : null);
                    print.setBarcode1(StringUtils.isNotBlank(contents_1[1]) ? Integer.parseInt(contents_1[1]) : null);
                    print.setSign1(StringUtils.isNotBlank(contents_1[2]) ? Integer.parseInt(contents_1[2]) : null);
                    print.setType2(StringUtils.isNotBlank(contents_1[3]) ? Integer.parseInt(contents_1[3]) : null);
                    print.setBarcode2(StringUtils.isNotBlank(contents_1[4]) ? Integer.parseInt(contents_1[4]) : null);
                    print.setSign2(StringUtils.isNotBlank(contents_1[5]) ? Integer.parseInt(contents_1[5]) : null);
                    break;
                case 2:
                    unPackage = this.contents_copyOfRange(unPackage.getSurplusContents(), 7);
                    this.setText(new DTextV1().setTexts(Arrays.asList(((PublicUnPackageArray) unPackage).getContents())));
                    break;
                case 3:
                    unPackage = new DTimeV2().Public_UnPackage(unPackage.getSurplusContents());
                    this.setTime((DTimeV2) ((PublicUnPackageObject) unPackage).getObj());
                    break;
                case 4:
                    DPriceV2 price_4 = this.getPrice();
                    if (price_4 == null) {
                        price_4 = new DPriceV2();
                        this.setPrice(price_4);
                    }

                    unPackage = this.contents_copyOfRange(unPackage.getSurplusContents(), 4);
                    String[] contents_ManualDiscount = ((PublicUnPackageArray) unPackage).getContents();
                    boolean hasManualDiscount = false;
                    for (String s : contents_ManualDiscount) {
                        if (StringUtils.isNotBlank(s)) {
                            hasManualDiscount = true;
                            break;
                        }
                    }
                    if (hasManualDiscount) {
                        price_4.addManualDiscounts(
                                new DManualDiscount(Restriction.上限.getRestriction(),
                                        StringUtils.isNotBlank(contents_ManualDiscount[0]) ? Integer.parseInt(contents_ManualDiscount[0]) : 0,
                                        StringUtils.isNotBlank(contents_ManualDiscount[2]) ? BigDecimalUtils.stringToBigDecimal(contents_ManualDiscount[2]) : null),
                                new DManualDiscount(Restriction.下限.getRestriction(),
                                        StringUtils.isNotBlank(contents_ManualDiscount[1]) ? Integer.parseInt(contents_ManualDiscount[1]) : 0,
                                        StringUtils.isNotBlank(contents_ManualDiscount[3]) ? BigDecimalUtils.stringToBigDecimal(contents_ManualDiscount[3]) : null));
                    }

                    List list = new ArrayList();
                    for (int i = 0; i < 4; i++) {
                        unPackage = this.contents_copyOfRange(unPackage.getSurplusContents(), 5);
                        String[] contents_AutoDiscount = ((PublicUnPackageArray) unPackage).getContents();
                        boolean hasAutoDiscount = false;
                        for (String s : contents_AutoDiscount) {
                            if (StringUtils.isNotBlank(s)) {
                                hasAutoDiscount = true;
                                break;
                            }
                        }
                        if (hasAutoDiscount) {
                            PublicUnPackageObject unPackageAutoDiscount = new DAutoDiscountV2().Public_UnPackage(contents_AutoDiscount);
                            list.add(unPackageAutoDiscount.getObj());
                        } else {
                            list.add(null);
                        }
                    }
                    for (Object o : list) {
                        if (o != null) {
                            price_4.setAutoDiscounts(list);
                            break;
                        }
                    }
                    break;
                case 5:
                    unPackage = this.contents_copyOfRange(unPackage.getSurplusContents(), 3);
                    String[] contents_5 = ((PublicUnPackageArray) unPackage).getContents();
                    DPrintWithBitMapV1 print_b = this.getPrint();
                    if (print_b == null) {
                        print = new DPrintWithBitMapV1();
                        this.setPrint(print);
                    }

                    String sign = ByteUtils.appendFill(Integer.toBinaryString(Integer.parseInt(contents_5[0])), 4);
                    if (UnitType.计件.equals(UnitEnum.unit(this.getUnit()).getType())) {
                        if (sign.charAt(3) == '1') this.setUnitText(this.getText().getTexts().get(6));
                        this.setSaveAsWeight(sign.charAt(2) == '1' ? 1 : 0);
                    } else {
                        if (sign.charAt(2) == '1')
                            this.setFixedWeight(BigDecimalUtils.stringToBigDecimal(contents_5[1]));
                        if (sign.charAt(3) == '1')
                            this.setPercentTare(BigDecimalUtils.stringToBigDecimal(contents_5[1]));
                    }

                    print_b.setBitmap(StringUtils.isNotBlank(contents_5[2]) ? Integer.parseInt(contents_5[2]) : null);
                    break;
                case 6:
                    unPackage = this.contents_copyOfRange(unPackage.getSurplusContents(), 1);
                    String[] contents_6 = ((PublicUnPackageArray) unPackage).getContents();
                    if (contents_6 != null && contents_6.length == 1 && StringUtils.isNotBlank(contents_6[0])) {
                        String[] parts = contents_6[0].split(DP_SPLIT2_1);
                        for (String part : parts) {
                            if (StringUtils.isNotBlank(part)) {
                                String[] fields = part.split(DP_SPLIT1);
                                if (fields.length > 0) {
                                    this.toOtherPrice(fields);
                                }
                            }
                        }
                    }
                    break;
                case 7:
                    unPackage = this.contents_copyOfRange(unPackage.getSurplusContents(), 1);
                    String[] contents_7 = ((PublicUnPackageArray) unPackage).getContents();
                    if (contents_7 != null && contents_7.length == 1 && StringUtils.isNotBlank(contents_7[0])) {
                        this.setAiType((DAIType) new DAIType().Public_UnPackage_No_Reflex(contents_7[0]));
                    }
                    break;
            }
        } catch (Exception e) {
        }
        return unPackage;
    }

    /**
     * @description: 组装等级价格
     **/
    default String to_otherPrices(Map<Integer, DPriceV2> otherPrices) {
        StringBuilder builder = new StringBuilder();
        if (otherPrices != null && !otherPrices.isEmpty()) {
            for (Map.Entry<Integer, DPriceV2> entry : otherPrices.entrySet()) {
                Integer key = entry.getKey();
                DPriceV2 value = entry.getValue();
                if (key != null && value != null) {
                    BigDecimal price = value.getPrice();
                    if (price != null) {
                        builder.append(key)
                                .append(DP_P)
                                .append(DP_SPLIT1)
                                .append(BigDecimalUtils.bigDecimalToString(price))
                                .append(DP_SPLIT2);
                    }

                    List<DManualDiscount> otherManualDiscounts = value.getManualDiscounts();
                    if (otherManualDiscounts != null && !otherManualDiscounts.isEmpty()) {
                        DManualDiscount upperManualDiscount = value.manualDiscount(Restriction.上限.getRestriction());
                        DManualDiscount lowerManualDiscount = value.manualDiscount(Restriction.下限.getRestriction());
                        builder.append(key)
                                .append(DP_M)
                                .append(DP_SPLIT1)
                                .append(lowerManualDiscount.getType())
                                .append(DP_SPLIT1)
                                .append(upperManualDiscount.getType())
                                .append(DP_SPLIT1)
                                .append(BigDecimalUtils.bigDecimalToString(lowerManualDiscount.getDiscount()))
                                .append(DP_SPLIT1)
                                .append(BigDecimalUtils.bigDecimalToString(upperManualDiscount.getDiscount()))
                                .append(DP_SPLIT2);
                    }

                    List<DAutoDiscountV2> otherAutoDiscounts = value.getAutoDiscounts();
                    if (otherAutoDiscounts != null && !otherAutoDiscounts.isEmpty()) {
                        for (int i = 0; i < otherAutoDiscounts.size(); i++) {
                            DAutoDiscountV2 autoDiscount = otherAutoDiscounts.get(i);
                            if (autoDiscount != null) {
                                builder.append(key)
                                        .append(DP_A + (i + 1))
                                        .append(DP_SPLIT1)
                                        .append(autoDiscount.type())
                                        .append(DP_SPLIT1)
                                        .append(autoDiscount.date())
                                        .append(DP_SPLIT1)
                                        .append(BigDecimalUtils.bigDecimalToString(autoDiscount.lower()))
                                        .append(DP_SPLIT1)
                                        .append(BigDecimalUtils.bigDecimalToString(autoDiscount.upper()))
                                        .append(DP_SPLIT1)
                                        .append(BigDecimalUtils.bigDecimalToString(autoDiscount.discount()))
                                        .append(DP_SPLIT2);
                            }
                        }
                    }
                }
            }
        }
        String content = builder.toString();
        if (StringUtils.isNotBlank(content))
            content = content.substring(0, content.length() - 1);
        return content;
    }

    /**
     * @description: 填充等级价格
     **/
    default void toOtherPrice(String[] other_price_part) {
        if (other_price_part[0].contains(DP_P)) {
            int index = other_price_part[0].indexOf(DP_P);
            int level = Integer.parseInt(other_price_part[0].substring(0, index));
            DPriceV2 level_price = this.levelPrice(level);
            level_price.setPrice(BigDecimalUtils.stringToBigDecimal(other_price_part[1]));
        } else if (other_price_part[0].contains(DP_M)) {
            int index = other_price_part[0].indexOf(DP_M);
            int level = Integer.parseInt(other_price_part[0].substring(0, index));
            DPriceV2 level_price = this.levelPrice(level);
            level_price.addManualDiscounts(
                    new DManualDiscount(Restriction.上限.getRestriction(),
                            other_price_part.length > 2 && StringUtils.isNotBlank(other_price_part[2]) ? Integer.parseInt(other_price_part[2]) : 0,
                            other_price_part.length > 4 && StringUtils.isNotBlank(other_price_part[4]) ? BigDecimalUtils.stringToBigDecimal(other_price_part[4]) : null),
                    new DManualDiscount(Restriction.下限.getRestriction(),
                            other_price_part.length > 1 && StringUtils.isNotBlank(other_price_part[1]) ? Integer.parseInt(other_price_part[1]) : 0,
                            other_price_part.length > 3 && StringUtils.isNotBlank(other_price_part[3]) ? BigDecimalUtils.stringToBigDecimal(other_price_part[3]) : null));
        } else if (other_price_part[0].contains(DP_A)) {
            int index = other_price_part[0].indexOf(DP_A);
            int level = Integer.parseInt(other_price_part[0].substring(0, index));
            int autoSerial = Integer.parseInt(other_price_part[0].substring(index + 1));
            DPriceV2 level_price = this.levelPrice(level);
            level_price.addAutoDiscounts(
                    autoSerial - 1,
                    new DAutoDiscountV2(
                            other_price_part.length > 1 && StringUtils.isNotBlank(other_price_part[1]) ? Integer.parseInt(other_price_part[1]) : 0,
                            other_price_part.length > 2 && StringUtils.isNotBlank(other_price_part[2]) ? Integer.parseInt(other_price_part[2]) : 0,
                            other_price_part.length > 3 && StringUtils.isNotBlank(other_price_part[3]) ? BigDecimalUtils.stringToBigDecimal(other_price_part[3]) : null,
                            other_price_part.length > 4 && StringUtils.isNotBlank(other_price_part[4]) ? BigDecimalUtils.stringToBigDecimal(other_price_part[4]) : null,
                            other_price_part.length > 5 && StringUtils.isNotBlank(other_price_part[5]) ? BigDecimalUtils.stringToBigDecimal(other_price_part[5]) : null
                    ));
        }
    }

    /**
     * @description: 获取单位
     **/
    Integer getUnit();

    /**
     * @description: 价格信息
     **/
    DPriceV2 getPrice();

    T setPrice(DPriceV2 price);

    Map<Integer, DPriceV2> getOtherPrices();

    T setOtherPrices(Map<Integer, DPriceV2> otherPrices);

    /**
     * @description: 其余等级价格，不存在创建空
     **/
    default DPriceV2 levelPrice(Integer level) {
        Map<Integer, DPriceV2> otherPrices = this.getOtherPrices();
        if (otherPrices == null) {
            otherPrices = new HashMap<>();
            this.setOtherPrices(otherPrices);
        }
        DPriceV2 price = otherPrices.get(level);
        if (price == null) {
            price = new DPriceV2();
            otherPrices.put(level, price);
        }
        return price;
    }

    /**
     * @description: 成本价
     **/
    BigDecimal costTrade();

    BigDecimal getCostTrade();

    T setCostTrade(BigDecimal costTrade);

    /**
     * @description: 皮重
     **/
    BigDecimal tare();

    BigDecimal getTare();

    T setTare(BigDecimal tare);

    /**
     * @description: 打印信息
     **/
    DPrintWithBitMapV1 getPrint();

    T setPrint(DPrintWithBitMapV1 print);

    /**
     * @description: 文本信息
     **/
    DTextV1 getText();

    T setText(DTextV1 text);

    /**
     * @description: 时间信息
     **/
    DTimeV2 getTime();

    T setTime(DTimeV2 time);

    /**
     * @description: 获取AI模型
     **/
    DAIType getAiType();

    /**
     * @description: 添加AI模型
     **/
    T setAiType(DAIType aiType);

    /**
     * @description: 计件单位 自定义量词
     * 计件取重
     * 特殊业务: 百分比皮重
     * 特殊业务: 固定重量(当unit!=2时有意义，当本业务启用, percentTare/tare均无用)
     **/
    String getUnitText();

    T setUnitText(String unitText);

    Integer getSaveAsWeight();

    T setSaveAsWeight(Integer saveAsWeight);

    default boolean saveAsWeight() {
        return this.getSaveAsWeight() == null ? false : this.getSaveAsWeight() == 1;
    }

    BigDecimal getPercentTare();

    T setPercentTare(BigDecimal percentTare);

    BigDecimal getFixedWeight();

    T setFixedWeight(BigDecimal fixedWeight);

}
