package com.jhscale.common.model.device.plu.inner;

import com.jhscale.common.model.device.plu.param.DAutoDiscountConstant;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Objects;

/**
 * @author lie_w
 * @title: DAutoDiscount
 * @projectName common
 * @description: 自动折扣信息
 * @date 2022/7/1519:41
 */
@Deprecated
public class DAutoDiscount extends DBParamSetting<DAutoDiscount> {

    @ApiModelProperty(value = "类型", name = "type")
    private Integer type;

    @ApiModelProperty(value = "激活日 默认 127", name = "date")
    private Integer date;

    @ApiModelProperty(value = "下限", name = "lower")
    private BigDecimal lower;

    @ApiModelProperty(value = "上限", name = "upper")
    private BigDecimal upper;

    @ApiModelProperty(value = "折扣数", name = "discount")
    private BigDecimal discount;

    @ApiModelProperty(value = "区间类型 0:区间内 ,1:区间外", name = "intervalType")
    private Integer intervalType;

    public Integer getType() {
        return type;
    }

    public DAutoDiscount setType(Integer type) {
        this.type = type;
        return this;
    }

    public Integer getDate() {
        return date;
    }

    public DAutoDiscount setDate(Integer date) {
        this.date = date;
        return this;
    }

    /**
     * @description: 添加星期
     **/
    public DAutoDiscount setDates(Integer... dates) {
        this.date = 0;
        if (dates != null && dates.length != 0) {
            for (Integer date : dates) {
                this.date += date;
            }
        }
        return this;
    }

    public BigDecimal getLower() {
        return lower;
    }

    public DAutoDiscount setLower(BigDecimal lower) {
        this.lower = lower;
        return this;
    }

    public BigDecimal getUpper() {
        return upper;
    }

    public DAutoDiscount setUpper(BigDecimal upper) {
        this.upper = upper;
        return this;
    }

    public BigDecimal getDiscount() {
        return discount;
    }

    public DAutoDiscount setDiscount(BigDecimal discount) {
        this.discount = discount;
        return this;
    }

    public Integer getIntervalType() {
        return intervalType;
    }

    public DAutoDiscount setIntervalType(Integer intervalType) {
        this.intervalType = intervalType;
        return this;
    }

    /**
     * @description: 自动折扣数值
     **/
    public String autoDiscount() {
        return new StringBuffer()
                .append(Objects.nonNull(this.type) ? this.type : DAutoDiscountConstant.AUTO_DISCOUNT_TYPE0)
                .append("#")
                .append(Objects.nonNull(this.date) ? this.date : DAutoDiscountConstant.NOD)
                .append("#")
                .append(Objects.nonNull(this.lower) ? this.lower : DAutoDiscountConstant.DEFAULT_DISCOUNT_VAL)
                .append("#")
                .append(Objects.nonNull(this.upper) ? this.upper : DAutoDiscountConstant.DEFAULT_DISCOUNT_VAL)
                .append("#")
                .append(Objects.nonNull(this.discount) ? this.discount : DAutoDiscountConstant.DEFAULT_DISCOUNT_VAL)
                .append("#")
                .append(Objects.nonNull(this.intervalType) ? this.intervalType : "")
                .toString();
    }
}
