package com.jhscale.common.model.device.plu.inner;

import com.alibaba.fastjson.annotation.JSONField;
import com.jhscale.common.annotation.BigDecimalToDouble;
import com.jhscale.common.annotation.DataClass;
import com.jhscale.common.annotation.PublicField;
import com.jhscale.common.annotation.StringToBigDecimal;
import com.jhscale.common.model.simple.FieldModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Objects;

import static com.jhscale.common.model.device.DConstant.*;

/**
 * @author lie_w
 * @title: DAutoDiscount
 * @projectName common
 * @description: 自动折扣信息
 * @date 2022/7/1519:41
 */
//@ApiModel("自动折扣V2")
@DataClass(separator = PUBLIC_FIELD_SPLIT_2)
public class DAutoDiscountV2<T extends DAutoDiscountV2> extends FieldModel<DAutoDiscountV2> {

    // @ApiModelProperty(value = "类型", name = "type")
    @PublicField(index = 1, type = INT)
    private Integer type;

    // @ApiModelProperty(value = "激活日 默认 127（1111111）", name = "date")
    @PublicField(index = 2, type = INT, defaultVal = "127")
    private Integer date;

    // @ApiModelProperty(value = "下限", name = "lower")
    @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = StringToBigDecimal.class)
    @PublicField(index = 3, type = BDL)
    private BigDecimal lower;

    // @ApiModelProperty(value = "上限", name = "upper")
    @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = StringToBigDecimal.class)
    @PublicField(index = 4, type = BDL)
    private BigDecimal upper;

    // @ApiModelProperty(value = "折扣数", name = "discount")
    @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = StringToBigDecimal.class)
    @PublicField(index = 5, type = BDL)
    private BigDecimal discount;

    public DAutoDiscountV2() {
    }

    public DAutoDiscountV2(Integer type, Integer date, BigDecimal lower, BigDecimal upper, BigDecimal discount) {
        this.type = type;
        this.date = date;
        this.lower = lower;
        this.upper = upper;
        this.discount = discount;
    }

    public Integer getType() {
        return type;
    }

    public Integer type() {
        return Objects.nonNull(this.type) ? this.type : 0;
    }

    public DAutoDiscountV2 setType(Integer type) {
        this.type = type;
        return this;
    }

    public Integer getDate() {
        return date;
    }

    public Integer date() {
        return Objects.nonNull(this.date) ? this.date : 127;
    }

    public DAutoDiscountV2 setDate(Integer date) {
        this.date = date;
        return this;
    }

    public BigDecimal getLower() {
        return lower;
    }

    public BigDecimal lower() {
        return Objects.nonNull(this.lower) ? this.lower : BigDecimal.ZERO;
    }

    public DAutoDiscountV2 setLower(BigDecimal lower) {
        this.lower = lower;
        return this;
    }

    public BigDecimal getUpper() {
        return upper;
    }

    public BigDecimal upper() {
        return Objects.nonNull(this.upper) ? this.upper : BigDecimal.ZERO;
    }

    public DAutoDiscountV2 setUpper(BigDecimal upper) {
        this.upper = upper;
        return this;
    }

    public BigDecimal getDiscount() {
        return discount;
    }

    public BigDecimal discount() {
        return Objects.nonNull(this.discount) ? this.discount : BigDecimal.ZERO;
    }

    public DAutoDiscountV2 setDiscount(BigDecimal discount) {
        this.discount = discount;
        return this;
    }

}
