package com.jhscale.common.model.device.plu.inner;

import com.alibaba.fastjson.annotation.JSONField;
import com.jhscale.common.annotation.BigDecimalToDouble;
import com.jhscale.common.annotation.DoubleToBigDecimal;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;

/**
 * @author lie_w
 * @title: DBBigDecimalParamSetting
 * @projectName common
 * @description: BigDecimal参数设置
 * @date 2022/7/1519:48
 */
public class DBBigDecimalParamSetting<T extends DBBigDecimalParamSetting> extends DBParamSetting<T> {

    @ApiModelProperty(value = "BigDecimal 参数值", name = "val")
    @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = DoubleToBigDecimal.class)
    private BigDecimal val;

    public DBBigDecimalParamSetting() {
    }

    public DBBigDecimalParamSetting(BigDecimal val) {
        this.val = val;
    }

    public T setVal(BigDecimal val) {
        this.val = val;
        return (T) this;
    }

    public BigDecimal getVal() {
        return val;
    }
}
