package com.jhscale.common.model.device.plu.inner;

import com.alibaba.fastjson.annotation.JSONField;
import com.jhscale.common.annotation.*;
import com.jhscale.common.model.device.plu.em.Restriction;
import com.jhscale.common.model.device.plu.param.DManualDiscountConstant;
import com.jhscale.common.model.simple.FieldModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Objects;

import static com.jhscale.common.model.device.DConstant.*;

/**
 * @author lie_w
 * @title: DManualDiscount
 * @projectName common
 * @description: 手动折扣信息
 * @date 2022/7/1519:40
 */
@ApiModel("手动折扣信息")
@DataClass(separator = PUBLIC_FIELD_SPLIT_2)
public class DManualDiscount<T extends DManualDiscount> extends FieldModel {

    // @ApiModelProperty(value = "手动折扣限制 （0，上限；1-下限）", name = "restriction")
    @PublicField(index = 1, type = INT)
    private Integer restriction;

    // @ApiModelProperty(value = "手动折扣类型 ， 0 ：使用系统设定， 1：无上限 2： 以原始单价为上限 3：已设定数字为上限", name = "type")
    @PublicField(index = 2, type = INT)
    private Integer type;

    // @ApiModelProperty(value = "折扣值", name = "discount")
    @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = StringToBigDecimal.class)
    @PublicField(index = 3, type = BDL)
    private BigDecimal discount;

    public DManualDiscount() {
    }

    public DManualDiscount(Restriction restriction, Integer type, BigDecimal discount) {
        this.restriction = restriction.getRestriction();
        this.type = type;
        this.discount = discount;
    }

    public DManualDiscount(Integer restriction, Integer type, BigDecimal discount) {
        this.restriction = restriction;
        this.type = type;
        this.discount = discount;
    }

    public DManualDiscount(Integer restriction) {
        this.restriction = restriction;
    }

    /**
     * @description: 手动上限
     **/
    public static class DUpperManualDiscount extends DManualDiscount<DUpperManualDiscount> {
        public DUpperManualDiscount() {
            super(DManualDiscountConstant.UPPER);
        }
    }

    /**
     * @description: 手动下限
     **/
    public static class DLowerManualDiscount extends DManualDiscount<DLowerManualDiscount> {
        public DLowerManualDiscount() {
            super(DManualDiscountConstant.LOWER);
        }
    }

    /**
     * @description: 设置手动折扣
     **/
    public T setDiscount(Integer type, BigDecimal discount) {
        this.type = type;
        this.discount = discount;
        return (T) this;
    }

    /**
     * @description: 设置手动折扣
     **/
    public DManualDiscount setDiscount(Integer restriction, Integer type, BigDecimal discount) {
        this.restriction = restriction;
        this.type = type;
        this.discount = discount;
        return this;
    }

    public Integer restriction() {
        return Objects.nonNull(this.restriction) ? this.restriction : -1;
    }

    public Integer getRestriction() {
        return restriction;
    }

    public DManualDiscount setRestriction(Integer restriction) {
        this.restriction = restriction;
        return this;
    }

    public DManualDiscount restriction(Restriction restriction) {
        this.restriction = restriction.getRestriction();
        return this;
    }

    public Integer type() {
        return Objects.nonNull(this.type) ? this.type : -1;
    }

    public Integer getType() {
        return type;
    }

    public DManualDiscount setType(Integer type) {
        this.type = type;
        return this;
    }

    public BigDecimal discount() {
        return Objects.nonNull(this.discount) ? this.discount : BigDecimal.ZERO;
    }

    public BigDecimal getDiscount() {
        return discount;
    }

    public DManualDiscount setDiscount(BigDecimal discount) {
        this.discount = discount;
        return this;
    }
}
