package com.jhscale.common.model.device.plu.inner;

import com.jhscale.common.model.simple.FieldModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * @author lie_w
 * @title: DPrintInfo
 * @projectName common
 * @description: 打印信息
 * @date 2022/7/1519:54
 */
public class DPrintInfo extends FieldModel {

    @ApiModelProperty(value = "打印格式", name = "type")
    private DPrintType type;

    @ApiModelProperty(value = "打印条码", name = "barcode")
    private DPrintBarcode barcode;

    @ApiModelProperty(value = "打印标志", name = "sign")
    private Integer sign;

    public DPrintInfo() {
    }

    public DPrintInfo(DPrintType type, DPrintBarcode barcode, Integer sign) {
        this.type = type;
        this.barcode = barcode;
        this.sign = sign;
    }

    public DPrintType getType() {
        return type;
    }

    public DPrintInfo setType(DPrintType type) {
        this.type = type;
        return this;
    }

    public DPrintBarcode getBarcode() {
        return barcode;
    }

    public DPrintInfo setBarcode(DPrintBarcode barcode) {
        this.barcode = barcode;
        return this;
    }

    public Integer getSign() {
        return sign;
    }

    public DPrintInfo setSign(Integer sign) {
        this.sign = sign;
        return this;
    }
}
