package com.jhscale.common.model.device.plu.inner;

import com.jhscale.common.model.device.UnitType;
import com.jhscale.common.model.simple.FieldModel;
import com.jhscale.common.ysscale.UnitEnum;
import io.swagger.annotations.ApiModelProperty;

/**
 * @author lie_w
 * @title: Unit
 * @projectName common
 * @description: 单位信息
 * @date 2022/7/1519:11
 */
public class DUnit extends FieldModel {

    @ApiModelProperty(value = "单位类型", name = "type")
    private UnitType type;

    @ApiModelProperty(value = "单位唯一识别码", name = "unitCode")
    private Long unitCode;

    @ApiModelProperty(value = "单位值 (条码秤 为秤单位识别码 其余为实际单位)", name = "unit")
    private String unit;

    @ApiModelProperty(value = "条码秤 秤单位识别码翻译信息", name = "dunit")
    private String dunit;

    public DUnit() {
    }

    public DUnit(UnitEnum unitEnum, Long unitCode, String unit) {
        this.unitCode = unitCode;
        if (UnitType.计件.equals(unitEnum)) {
            this.type = UnitType.计件;
            this.unit = unit;
        } else {
            this.type = UnitType.计重;
            this.unit = unitEnum.getVal();
            this.dunit = unitEnum.getName();
        }
    }

    public DUnit(UnitType type, Long unitCode, String unit) {
        this.type = type;
        this.unitCode = unitCode;
        this.unit = unit;
    }

    public DUnit(UnitType type, Long unitCode, String unit, String dunit) {
        this.type = type;
        this.unitCode = unitCode;
        this.unit = unit;
        this.dunit = dunit;
    }

    public UnitType getType() {
        return type;
    }

    public DUnit setType(UnitType type) {
        this.type = type;
        return this;
    }

    public Long getUnitCode() {
        return unitCode;
    }

    public DUnit setUnitCode(Long unitCode) {
        this.unitCode = unitCode;
        return this;
    }

    public String getUnit() {
        return unit;
    }

    public DUnit setUnit(String unit) {
        this.unit = unit;
        return this;
    }

    public String getDunit() {
        return dunit;
    }

    public DUnit setDunit(String dunit) {
        this.dunit = dunit;
        return this;
    }
}
