package com.jhscale.common.model.device.plu.module;

import com.jhscale.common.annotation.DataClass;
import com.jhscale.common.annotation.PublicField;
import com.jhscale.common.model.simple.FieldModel;
import org.apache.commons.lang3.StringUtils;

import static com.jhscale.common.model.device.DConstant.*;

/**
 * @author lie_w
 * @title: AIModel
 * @projectName common
 * @description: TODO
 * @date 2023/2/169:18
 */
// @ApiModel("AI 模型信息")
@DataClass(separator = DP_SPLIT1)
public class DAIModel extends FieldModel {

    // @ApiModelProperty(value = "AI模型编号", name = "model")
    @PublicField(index = 1, type = TXT_M1, defaultVal = "M")
    private String model;

    // @ApiModelProperty(value = "AI模型名称", name = "name")
    @PublicField(index = 2, type = TXT, defaultVal = "M")
    private String name;

    public DAIModel() {
    }

    public DAIModel(String model) {
        int index = model.indexOf(DP_SPLIT1);
        if (index == -1) {
            this.model = model;
        } else {
            this.model = model.substring(0, index);
            this.name = model.substring(index + 1);
        }
    }

    public String name() {
        return StringUtils.isNotBlank(this.name) ? this.name : "";
    }

    public DAIModel(String model, String name) {
        this.model = model;
        this.name = name;
    }

    public String label_str() {
        return String.format("%s_%s", this.getModel(), this.getName());
    }

    public String getModel() {
        return model;
    }

    public DAIModel setModel(String model) {
        this.model = model;
        return this;
    }

    public String getName() {
        return name;
    }

    public DAIModel setName(String name) {
        this.name = name;
        return this;
    }
}
