package com.jhscale.common.model.device.plu.module;

import com.jhscale.common.annotation.DataClass;
import com.jhscale.common.annotation.PublicField;
import com.jhscale.common.model.simple.FieldModel;

import java.util.Objects;

import static com.jhscale.common.model.device.DConstant.*;

/**
 * @author lie_w
 * @title: AIModel
 * @projectName common
 * @description: TODO
 * @date 2023/2/169:18
 */
// @ApiModel("其他 AI 模型信息")
@DataClass(separator = PUBLIC_SET_FIELD_SPLIT_2)
public class DAIOther extends FieldModel {

    // @ApiModelProperty(value = "AI模型编号", name = "model")
    @PublicField(index = 1, type = TXT_M1, defaultVal = "M")
    private String model;

    // @ApiModelProperty(value = "AI模型名称", name = "name")
    @PublicField(index = 2, type = DOUBLE, defaultVal = "0.0")
    private Double percent;

    public DAIOther() {
    }

    public DAIOther(String model) {
        int index = model.indexOf(DP_SPLIT4);
        if (index == -1) {
            this.model = model;
        } else {
            this.model = model.substring(0, index);
            this.percent = Double.parseDouble(model.substring(index + 1));
        }
    }

    public DAIOther(String model, Double percent) {
        this.model = model;
        this.percent = percent;
    }

    public Double percent() {
        return Objects.nonNull(this.percent) ? this.percent : 0.0;
    }

    public String getModel() {
        return model;
    }

    public DAIOther setModel(String model) {
        this.model = model;
        return this;
    }

    public Double getPercent() {
        return percent;
    }

    public DAIOther setPercent(Double percent) {
        this.percent = percent;
        return this;
    }
}
