package com.jhscale.common.model.device.plu.module;

import com.jhscale.common.annotation.DataClass;
import com.jhscale.common.annotation.PublicField;
import com.jhscale.common.model.inter.DataJSONModel;
import com.jhscale.common.model.simple.FieldModel;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

import static com.jhscale.common.model.device.DConstant.*;

/**
 * @author lie_w
 * @title: DAIType
 * @projectName common
 * @description: TODO
 * @date 2023/1/1113:16
 */
// @ApiModel("AI Type信息")
@DataClass(separator = PUBLIC_FIELD_SPLIT_1)
public class DAIType extends FieldModel {

    // @ApiModelProperty(value = "商品类型(0|Null-普通商品(默认),1-AI商品 (训练过的商品),2-AI待训练商品)", name = "pluType")
    @PublicField(index = 1, type = INT, defaultVal = "0")
    private Integer type;

    // @ApiModelProperty(value = "模型列表", name = "models")
    @PublicField(index = 2, type = LST, list_type = FML, list_class = DAIModel.class)
    private List<DAIModel> models;

    // @ApiModelProperty(value = "其他模型参数信息", name = "others")
    @PublicField(index = 3, type = LST, list_type = FML, list_class = DAIOther.class)
    private List<DAIOther> others;

    public DAIType() {
    }

    public DAIType(String content) {
        this.Public_UnPackage_No_Reflex(content);
    }

    public Integer type() {
        return Objects.nonNull(this.type) ? this.type : 0;
    }

    /**
     * @description: 打包打印数据内容
     **/
    public String toPackage() {
        return this.Public_Package_No_Reflex().toString();
    }

    /**
     * @description: 公开协议 组包 不使用反射
     **/
    @Override
    public StringBuilder Public_Package_No_Reflex() {
        StringBuilder builder = super.Public_Package_No_Reflex()
                .append(this.type())
                .append(PUBLIC_FIELD_SPLIT_1)
                .append(this.models());
        if (this.others != null && !this.others.isEmpty()) {
            builder.append(PUBLIC_SET_FIELD_SPLIT)
                    .append(this.others());
        }
        return builder;

    }

    /**
     * @param content
     * @description: 公开协议 拆包
     */
    @Override
    public DataJSONModel Public_UnPackage_No_Reflex(String content) {
        if (StringUtils.isNotBlank(content)) {
            int index = content.indexOf(PUBLIC_FIELD_SPLIT_1);
            if (index == -1) {
                index = content.indexOf(PUBLIC_SET_FIELD_SPLIT);
                if (index == -1) {
                    this.type = Integer.parseInt(content);
                    return this;
                }
            }
            this.type = Integer.parseInt(content.substring(0, 1));
            content = content.substring(index + 1);
            if (StringUtils.isNotBlank(content)) {
                String[] ps = content.split(PUBLIC_SET_FIELD_SPLIT);
                if (ps.length > 0) {
                    for (String p : ps) {
                        if (StringUtils.isNotBlank(p)) {
                            if (p.contains(DP_SPLIT1)) {
                                int im = p.indexOf(DP_SPLIT1);
                                if (im == -1) {
                                    this.addModels(new DAIModel(p, null));
                                } else {
                                    this.addModels(new DAIModel(p.substring(0, im), p.substring(im + 1)));
                                }
                            } else if (p.contains(DP_SPLIT4)) {
                                String[] ops = p.split(PUBLIC_SET_FIELD_SPLIT_2);
                                if (ops.length > 0) {
                                    for (String op : ops) {
                                        if (StringUtils.isNotBlank(op)) {
                                            int imo = op.indexOf(DP_SPLIT4);
                                            if (imo == -1) {
                                                this.addModels(new DAIModel(op, null));
                                            } else {
                                                String percent = op.substring(imo + 1);
                                                this.addOthers(new DAIOther(op.substring(0, imo), StringUtils.isNotBlank(percent) ? Double.parseDouble(percent) : null));
                                            }
                                        }
                                    }
                                }
                            } else {
                                this.addModels(new DAIModel(p, null));
                            }
                        }
                    }
                }
            }
        }
        return this;
    }

    /**
     * @description: 添加模型信息
     **/
    public DAIType addModels(DAIModel... models) {
        if (models != null && models.length > 0) {
            if (this.models == null) this.models = new ArrayList<>();
            this.models.addAll(Arrays.asList(models));
        }
        return this;
    }

    /**
     * @description: 其他模型参数
     **/
    public DAIType addOthers(DAIOther... others) {
        if (others != null && others.length > 0) {
            if (this.others == null) this.others = new ArrayList<>();
            this.others.addAll(Arrays.asList(others));
        }
        return this;
    }

    /**
     * @description: 基础 AI 信息
     **/
    public StringBuilder models() {
        StringBuilder builder = new StringBuilder();
        if (this.models != null && !this.models.isEmpty()) {
            for (int i = 0; i < this.models.size(); i++) {
                DAIModel daiModel = this.models.get(i);
                if (daiModel != null && StringUtils.isNotBlank(daiModel.getModel())) {
                    builder.append(daiModel.getModel())
                            .append(DP_SPLIT1)
                            .append(daiModel.name())
                            .append(i != this.models.size() - 1 ? PUBLIC_SET_FIELD_SPLIT : "");
                }
            }
        }
        return builder;
    }

    /**
     * @description: 复杂 AI 信息
     **/
    public StringBuilder others() {
        StringBuilder builder = new StringBuilder();
        if (this.others != null && !this.others.isEmpty()) {
            for (int i = 0; i < this.others.size(); i++) {
                DAIOther daiOther = this.others.get(i);
                if (daiOther != null && StringUtils.isNotBlank(daiOther.getModel())) {
                    builder.append(daiOther.getModel())
                            .append(DP_SPLIT4)
                            .append(daiOther.percent())
                            .append(PUBLIC_SET_FIELD_SPLIT_2);
                }
            }
        }
        return builder;
    }

    public Integer getType() {
        return type;
    }

    public DAIType setType(Integer type) {
        this.type = type;
        return this;
    }

    public List<DAIModel> getModels() {
        return models;
    }

    public DAIType setModels(List<DAIModel> models) {
        this.models = models;
        return this;
    }

    public List<DAIOther> getOthers() {
        return others;
    }

    public DAIType setOthers(List<DAIOther> others) {
        this.others = others;
        return this;
    }
}
