package com.jhscale.common.model.device.plu.module;

import com.jhscale.common.model.device.plu.inner.DAutoDiscount;
import com.jhscale.common.model.device.plu.inner.DManualDiscount;
import com.jhscale.common.model.device.plu.param.DManualDiscountConstant;
import com.jhscale.common.model.simple.FieldModel;
import com.jhscale.common.utils.DPLUUtils;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;

/**
 * @author lie_w
 * @title: DPrice
 * @projectName common
 * @description: 价格信息
 * @date 2022/7/1519:14
 */
@Deprecated
public class DPrice extends FieldModel {

    @ApiModelProperty(value = "单价", name = "price")
    private BigDecimal price;
    @ApiModelProperty(value = "手动折扣", name = "手动折扣")
    private String manualDiscount;
    @ApiModelProperty(value = "自动折扣1", name = "autoDiscount1")
    private String autoDiscount1;
    @ApiModelProperty(value = "自动折扣2", name = "autoDiscount2")
    private String autoDiscount2;
    @ApiModelProperty(value = "自动折扣3", name = "autoDiscount3")
    private String autoDiscount3;
    @ApiModelProperty(value = "自动折扣4", name = "autoDiscount4")
    private String autoDiscount4;

    public BigDecimal getPrice() {
        return price;
    }

    public DPrice setPrice(BigDecimal price) {
        this.price = price;
        return this;
    }

    public String getManualDiscount() {
        return manualDiscount;
    }

    public DPrice setManualDiscount(String manualDiscount) {
        this.manualDiscount = manualDiscount;
        return this;
    }

    public String getAutoDiscount1() {
        return autoDiscount1;
    }

    public DPrice setAutoDiscount1(String autoDiscount1) {
        this.autoDiscount1 = autoDiscount1;
        return this;
    }

    public String getAutoDiscount2() {
        return autoDiscount2;
    }

    public DPrice setAutoDiscount2(String autoDiscount2) {
        this.autoDiscount2 = autoDiscount2;
        return this;
    }

    public String getAutoDiscount3() {
        return autoDiscount3;
    }

    public DPrice setAutoDiscount3(String autoDiscount3) {
        this.autoDiscount3 = autoDiscount3;
        return this;
    }

    public String getAutoDiscount4() {
        return autoDiscount4;
    }

    public DPrice setAutoDiscount4(String autoDiscount4) {
        this.autoDiscount4 = autoDiscount4;
        return this;
    }

    /**
     * @description: 添加手动折扣
     **/
    public DPrice addManualDiscount(DManualDiscount.DUpperManualDiscount upper, DManualDiscount.DLowerManualDiscount lower) {
        this.manualDiscount = new StringBuffer()
                .append(Objects.nonNull(upper) ? (Objects.nonNull(upper.getRestriction()) ? upper.getRestriction().toString() : "") : "")
                .append("#")
                .append(Objects.nonNull(lower) ? (Objects.nonNull(lower.getRestriction()) ? lower.getRestriction().toString() : "") : "")
                .append("|")
                .append(Objects.nonNull(upper) ? (Objects.nonNull(upper.getType()) ? upper.getType().toString() : "") : "")
                .append("#")
                .append(Objects.nonNull(lower) ? (Objects.nonNull(lower.getType()) ? lower.getType().toString() : "") : "")
                .append("|")
                .append(Objects.nonNull(upper) ? (Objects.nonNull(upper.getDiscount()) ? upper.getDiscount().toString() : "") : "")
                .append("#")
                .append(Objects.nonNull(lower) ? (Objects.nonNull(lower.getDiscount()) ? lower.getDiscount().toString() : "") : "")
                .toString();
        return this;
    }

    /**
     * @description: 添加手动折扣
     **/
    public DPrice addManualDiscount(List<DManualDiscount> discounts) {
        if (discounts != null) {
            DManualDiscount.DUpperManualDiscount upper = null;
            DManualDiscount.DLowerManualDiscount lower = null;
            for (DManualDiscount discount : discounts) {
                if (DManualDiscountConstant.UPPER.equals(discount.getRestriction())) {
                    upper = discount.toObject(DManualDiscount.DUpperManualDiscount.class);
                }
                if (DManualDiscountConstant.LOWER.equals(discount.getRestriction())) {
                    lower = discount.toObject(DManualDiscount.DLowerManualDiscount.class);
                }
            }
            return this.addManualDiscount(upper, lower);
        }
        return this;
    }

    /**
     * @description: 添加自动折扣1
     **/
    public DPrice addAutoDiscount1(DAutoDiscount autoDiscount) {
        if (autoDiscount == null) autoDiscount = new DAutoDiscount();
        this.autoDiscount1 = autoDiscount.autoDiscount();
        return this;
    }

    /**
     * @description: 添加自动折扣2
     **/
    public DPrice addAutoDiscount2(DAutoDiscount autoDiscount) {
        if (autoDiscount == null) autoDiscount = new DAutoDiscount();
        this.autoDiscount2 = autoDiscount.autoDiscount();
        return this;
    }

    /**
     * @description: 添加自动折扣3
     **/
    public DPrice addAutoDiscount3(DAutoDiscount autoDiscount) {
        if (autoDiscount == null) autoDiscount = new DAutoDiscount();
        this.autoDiscount3 = autoDiscount.autoDiscount();
        return this;
    }

    /**
     * @description: 添加自动折扣4
     **/
    public DPrice addAutoDiscount4(DAutoDiscount autoDiscount) {
        if (autoDiscount == null) autoDiscount = new DAutoDiscount();
        this.autoDiscount4 = autoDiscount.autoDiscount();
        return this;
    }


    /**
     * @description: 获取手动折扣方法
     **/
    public List<DManualDiscount> obtainManualDiscount() {
        return DPLUUtils.getDManualDiscount(manualDiscount);
    }

    /**
     * @description: 获取自动折扣1
     **/
    public DAutoDiscount obtainAutoDiscount1() {
        return DPLUUtils.getAutoDiscount(autoDiscount1);
    }

    /**
     * @description: 获取自动折扣2
     **/
    public DAutoDiscount obtainAutoDiscount2() {
        return DPLUUtils.getAutoDiscount(autoDiscount2);
    }

    /**
     * @description: 获取自动折扣3
     **/
    public DAutoDiscount obtainAutoDiscount3() {
        return DPLUUtils.getAutoDiscount(autoDiscount3);
    }

    /**
     * @description: 获取自动折扣4
     **/
    public DAutoDiscount obtainAutoDiscount4() {
        return DPLUUtils.getAutoDiscount(autoDiscount4);
    }
}
