package com.jhscale.common.model.device.plu.module;

import com.alibaba.fastjson.annotation.JSONField;
import com.jhscale.common.annotation.BigDecimalToDouble;
import com.jhscale.common.annotation.DataClass;
import com.jhscale.common.annotation.PublicField;
import com.jhscale.common.annotation.StringToBigDecimal;
import com.jhscale.common.model.device.plu.inner.DAutoDiscountV2;
import com.jhscale.common.model.device.plu.inner.DManualDiscount;
import com.jhscale.common.model.simple.FieldModel;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

import static com.jhscale.common.model.device.DConstant.*;

/**
 * @author lie_w
 * @title: DPrice
 * @projectName common
 * @description: 价格信息
 * @date 2022/7/1519:14
 */
// @ApiModel("价格信息V2")
@DataClass(separator = PUBLIC_FIELD_SPLIT_1)
public class DPriceV2 extends FieldModel {

    @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = StringToBigDecimal.class)
    // @ApiModelProperty(value = "单价", name = "price")
    @PublicField(index = 1, type = BDL)
    private BigDecimal price;

    // @ApiModelProperty(value = "手动折扣", name = "manualDiscounts")
    @PublicField(index = 2, type = LST,
            list_type = FML, list_class = DManualDiscount.class,
            set_split = PUBLIC_SET_FIELD_SPLIT_1)
    private List<DManualDiscount> manualDiscounts;

    // @ApiModelProperty(value = "自动折扣", name = "autoDiscounts")
    @PublicField(index = 3, type = LST,
            list_type = FML, list_class = DAutoDiscountV2.class,
            set_split = PUBLIC_SET_FIELD_SPLIT_1)
    private List<DAutoDiscountV2> autoDiscounts;

    public BigDecimal price() {
        return Objects.nonNull(this.price) ? this.price : BigDecimal.ZERO;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public DPriceV2 setPrice(BigDecimal price) {
        this.price = price;
        return this;
    }

    public List<DManualDiscount> getManualDiscounts() {
        return manualDiscounts;
    }

    public DPriceV2 setManualDiscounts(List<DManualDiscount> manualDiscounts) {
        this.manualDiscounts = manualDiscounts;
        return this;
    }

    public List<DAutoDiscountV2> getAutoDiscounts() {
        return autoDiscounts;
    }

    public DPriceV2 setAutoDiscounts(List<DAutoDiscountV2> autoDiscounts) {
        this.autoDiscounts = autoDiscounts;
        return this;
    }

    public DPriceV2 addManualDiscounts(DManualDiscount... manualDiscounts) {
        if (manualDiscounts != null && manualDiscounts.length > 0) {
            if (this.manualDiscounts == null) this.manualDiscounts = new ArrayList<>();
            this.manualDiscounts.addAll(Arrays.asList(manualDiscounts));
        }
        return this;
    }

    public DPriceV2 addAutoDiscounts(DAutoDiscountV2... autoDiscounts) {
        if (autoDiscounts != null && autoDiscounts.length > 0) {
            if (this.autoDiscounts == null) this.autoDiscounts = new ArrayList<>();
            this.autoDiscounts.addAll(Arrays.asList(autoDiscounts));
        }
        return this;
    }

    public DPriceV2 addAutoDiscounts(int index, DAutoDiscountV2 autoDiscount) {
        if (this.autoDiscounts == null) this.autoDiscounts = new ArrayList<>();
        if (index > this.autoDiscounts.size()) {
            int length = index - this.autoDiscounts.size();
            for (int i = 0; i < length; i++) {
                this.autoDiscounts.add(null);
            }
        }
        this.autoDiscounts.add(index, autoDiscount);
        return this;
    }

    /**
     * @description: 手动折扣 0，上限；1-下限
     **/
    public DManualDiscount manualDiscount(int type) {
        DManualDiscount manualDiscount = this._manualDiscount(type);
        return Objects.isNull(manualDiscount) ? new DManualDiscount(type, 0, BigDecimal.ZERO) : manualDiscount;
    }

    public DManualDiscount _manualDiscount(int type) {
        if (this.manualDiscounts != null && !this.manualDiscounts.isEmpty()) {
            for (DManualDiscount manualDiscount : manualDiscounts) {
                if (manualDiscount != null && type == manualDiscount.getRestriction()) return manualDiscount;
            }
        }
        return null;
    }

    /**
     * @description: 获取自动折扣
     **/
    public DAutoDiscountV2 _autoDiscount(int index) {
        if (this.autoDiscounts != null && this.autoDiscounts.size() > index) {
            return this.autoDiscounts.get(index);
        }
        return null;
    }
}
