package com.jhscale.common.model.device.plu.module;

import com.jhscale.common.annotation.DataClass;
import com.jhscale.common.annotation.PublicField;
import com.jhscale.common.model.simple.FieldModel;

import java.util.Objects;

import static com.jhscale.common.model.device.DConstant.INT;

/**
 * @author lie_w
 * @title: DPrint
 * @projectName common
 * @description: 打印信息
 * @date 2022/7/1613:32
 */
// @ApiModel("打印格式V2")
@DataClass
public class DPrintV2<T extends DPrintV2> extends FieldModel<T> {

    // @ApiModelProperty(value = "打印1格式", name = "type1")
    @PublicField(index = 1, type = INT)
    private Integer type1;

    // @ApiModelProperty(value = "打印1条码", name = "barcode1")
    @PublicField(index = 2, type = INT)
    private Integer barcode1;

    // @ApiModelProperty(value = "打印1标志", name = "sign1")
    @PublicField(index = 3, type = INT)
    private Integer sign1;

    // @ApiModelProperty(value = "打印2格式", name = "type2")
    @PublicField(index = 4, type = INT)
    private Integer type2;

    // @ApiModelProperty(value = "打印2条码", name = "barcode2")
    @PublicField(index = 5, type = INT)
    private Integer barcode2;

    // @ApiModelProperty(value = "打印2标志", name = "sign2")
    @PublicField(index = 6, type = INT)
    private Integer sign2;

    /*******************************默认值Get 方法*************************************/

    public Integer type1() {
        return Objects.nonNull(this.type1) ? this.type1 : 0;
    }

    public Integer barcode1() {
        return Objects.nonNull(this.barcode1) ? this.barcode1 : 0;
    }

    public Integer sign1() {
        return Objects.nonNull(this.sign1) ? this.sign1 : 0;
    }

    public Integer type2() {
        return Objects.nonNull(this.type2) ? this.type2 : 0;
    }

    public Integer barcode2() {
        return Objects.nonNull(this.barcode2) ? this.barcode2 : 0;
    }

    public Integer sign2() {
        return Objects.nonNull(this.sign2) ? this.sign2 : 0;
    }

    /*******************************默认值Get 方法*************************************/

    public Integer getType1() {
        return type1;
    }

    public T setType1(Integer type1) {
        this.type1 = type1;
        return (T) this;
    }

    public Integer getBarcode1() {
        return barcode1;
    }

    public T setBarcode1(Integer barcode1) {
        this.barcode1 = barcode1;
        return (T) this;
    }

    public Integer getSign1() {
        return sign1;
    }

    public T setSign1(Integer sign1) {
        this.sign1 = sign1;
        return (T) this;
    }

    public Integer getType2() {
        return type2;
    }

    public T setType2(Integer type2) {
        this.type2 = type2;
        return (T) this;
    }

    public Integer getBarcode2() {
        return barcode2;
    }

    public T setBarcode2(Integer barcode2) {
        this.barcode2 = barcode2;
        return (T) this;
    }

    public Integer getSign2() {
        return sign2;
    }

    public T setSign2(Integer sign2) {
        this.sign2 = sign2;
        return (T) this;
    }
}
