package com.jhscale.common.model.device.plu.module;

import com.jhscale.common.annotation.DataClass;
import com.jhscale.common.annotation.PublicField;

import java.util.Objects;

import static com.jhscale.common.model.device.DConstant.INT;
import static com.jhscale.common.model.device.DConstant.PUBLIC_FIELD_SPLIT_1;

/**
 * @author lie_w
 * @title: DPrint
 * @projectName common
 * @description: 打印信息
 * @date 2022/7/1613:32
 */
// @ApiModel("打印格式同位图V2")
@DataClass(separator = PUBLIC_FIELD_SPLIT_1)
public class DPrintWithBitMapV1 extends DPrintV2<DPrintWithBitMapV1> {

    // @ApiModelProperty(value = "位图信息", name = "bitmap")
    @PublicField(index = 7, type = INT)
    private Integer bitmap;

    /*******************************默认值Get 方法*************************************/

    public Integer bitmap() {
        return Objects.nonNull(this.bitmap) ? this.bitmap : 0;
    }

    /*******************************默认值Get 方法*************************************/

    public Integer getBitmap() {
        return bitmap;
    }

    public DPrintWithBitMapV1 setBitmap(Integer bitmap) {
        this.bitmap = bitmap;
        return this;
    }
}
