package com.jhscale.common.model.device.plu.module;

import com.alibaba.fastjson.annotation.JSONField;
import com.jhscale.common.annotation.BigDecimalToDouble;
import com.jhscale.common.annotation.DoubleToBigDecimal;
import com.jhscale.common.model.device.plu.inner.DPricture;
import com.jhscale.common.model.device.plu.inner.DUnit;
import com.jhscale.common.model.simple.FieldModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.*;

/**
 * @author lie_w
 * @title: DSpecification
 * @projectName common
 * @description: 规格
 * @date 2022/7/1519:13
 */
@Deprecated
public class DSpecificationV4 extends FieldModel {

    @ApiModelProperty(value = "规格编号", name = "code")
    private Long code;
    @ApiModelProperty(value = "商品编号（商户商品规格下不重复）", name = "no")
    private Integer no;
    @ApiModelProperty(value = "规格名称", name = "name")
    private String name;
    @ApiModelProperty(value = "图片", name = "pictures")
    private List<DPricture> pictures;
    @ApiModelProperty(value = "简写", name = "simple")
    private String simple;
    @ApiModelProperty(value = "规格上架状态", name = "state", example = "1-下架 2-正常，3-停售，4-缺货 ")
    private String state;
    @ApiModelProperty(value = "货号", name = "number")
    private Integer number;
    @ApiModelProperty(value = "规格条码", name = "indexBar")
    private String indexBar;
    @ApiModelProperty(value = "皮重", name = "trae")
    @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = DoubleToBigDecimal.class)
    private BigDecimal trae;
    @ApiModelProperty(value = "主单位信息", name = "masterUnit")
    private DUnit masterUnit;
    @ApiModelProperty(value = "计件取重", name = "pcsToWeight")
    private Integer pcsToWeight;
    @ApiModelProperty(value = "税率", name = "taxRate")
    @JSONField(serializeUsing = BigDecimalToDouble.class, deserializeUsing = DoubleToBigDecimal.class)
    private BigDecimal taxRate;

    @ApiModelProperty(value = "打印信息", name = "print")
    private DPrint print;
    @ApiModelProperty(value = "其余打印信息（店铺打印信息）", name = "otherPrints")
    private Map<String, DPrint> otherPrints;
    @ApiModelProperty(value = "时间信息", name = "time")
    private DTime time;
    @ApiModelProperty(value = "其余时间信息（店铺时间信息）", name = "otherTime")
    private Map<String, DTime> otherTime;
    @ApiModelProperty(value = "价格信息", name = "price")
    private DPrice price;
    @ApiModelProperty(value = "其余价格信息（店铺价格）", name = "otherPrices")
    private Map<String, DPrice> otherPrices;
    @ApiModelProperty(value = "文本内容 条码秤最大长度8 收银秤另说", name = "texts")
    private List<String> texts;
    @ApiModelProperty(value = "其余文本内容（店铺文本）", name = "otherTexts")
    private Map<String, List<String>> otherTexts;

    @ApiModelProperty(value = "其余信息", name = "others")
    private Map<String, Object> others;

    public Long getCode() {
        return code;
    }

    public DSpecificationV4 setCode(Long code) {
        this.code = code;
        return this;
    }

    public Integer getNo() {
        return no;
    }

    /**
     * @description: 编号
     **/
    @Override
    public Integer no() {
        return this.no;
    }

    public DSpecificationV4 setNo(Integer no) {
        this.no = no;
        return this;
    }

    public String getName() {
        return name;
    }

    public DSpecificationV4 setName(String name) {
        this.name = name;
        return this;
    }

    public List<DPricture> getPictures() {
        return pictures;
    }

    public DSpecificationV4 setPictures(List<DPricture> pictures) {
        this.pictures = pictures;
        return this;
    }

    public String getSimple() {
        return simple;
    }

    public DSpecificationV4 setSimple(String simple) {
        this.simple = simple;
        return this;
    }

    public String getState() {
        return state;
    }

    public DSpecificationV4 setState(String state) {
        this.state = state;
        return this;
    }

    public Integer getNumber() {
        return number;
    }

    public DSpecificationV4 setNumber(Integer number) {
        this.number = number;
        return this;
    }

    public String getIndexBar() {
        return indexBar;
    }

    public DSpecificationV4 setIndexBar(String indexBar) {
        this.indexBar = indexBar;
        return this;
    }

    public BigDecimal getTrae() {
        return trae;
    }

    public DSpecificationV4 setTrae(BigDecimal trae) {
        this.trae = trae;
        return this;
    }

    public DUnit getMasterUnit() {
        return masterUnit;
    }

    public DSpecificationV4 setMasterUnit(DUnit masterUnit) {
        this.masterUnit = masterUnit;
        return this;
    }

    public Integer getPcsToWeight() {
        return pcsToWeight;
    }

    public DSpecificationV4 setPcsToWeight(Integer pcsToWeight) {
        this.pcsToWeight = pcsToWeight;
        return this;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public DSpecificationV4 setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
        return this;
    }

    public DPrint getPrint() {
        return print;
    }

    public DSpecificationV4 setPrint(DPrint print) {
        this.print = print;
        return this;
    }

    public DTime getTime() {
        return time;
    }

    public DSpecificationV4 setTime(DTime time) {
        this.time = time;
        return this;
    }

    public DPrice getPrice() {
        return price;
    }

    public DSpecificationV4 setPrice(DPrice price) {
        this.price = price;
        return this;
    }

    public Map<String, DPrice> getOtherPrices() {
        return otherPrices;
    }

    public DSpecificationV4 setOtherPrices(Map<String, DPrice> otherPrices) {
        this.otherPrices = otherPrices;
        return this;
    }

    public List<String> getTexts() {
        return texts;
    }

    public DSpecificationV4 setTexts(List<String> texts) {
        this.texts = texts;
        return this;
    }

    public Map<String, DPrint> getOtherPrints() {
        return otherPrints;
    }

    public DSpecificationV4 setOtherPrints(Map<String, DPrint> otherPrints) {
        this.otherPrints = otherPrints;
        return this;
    }

    public Map<String, DTime> getOtherTime() {
        return otherTime;
    }

    public DSpecificationV4 setOtherTime(Map<String, DTime> otherTime) {
        this.otherTime = otherTime;
        return this;
    }

    public Map<String, List<String>> getOtherTexts() {
        return otherTexts;
    }

    public DSpecificationV4 setOtherTexts(Map<String, List<String>> otherTexts) {
        this.otherTexts = otherTexts;
        return this;
    }

    public Map<String, Object> getOthers() {
        return others;
    }

    public DSpecificationV4 setOthers(Map<String, Object> others) {
        this.others = others;
        return this;
    }

    /**
     * @description: 添加图片信息
     **/
    public DSpecificationV4 addPricture(DPricture... pictures) {
        if (this.pictures == null) this.pictures = new ArrayList<>();
        if (pictures != null && pictures.length != 0) {
            this.pictures.addAll(Arrays.asList(pictures));
        }
        return this;
    }

    /**
     * @description: 添加其他打印信息
     **/
    public DSpecificationV4 putOtherPrint(String sign, DPrint print) {
        if (this.otherPrints == null) this.otherPrints = new HashMap<>();
        this.otherPrints.put(sign, print);
        return this;
    }

    /**
     * @description: 添加其他时间信息
     **/
    public DSpecificationV4 putOtherTime(String sign, DTime time) {
        if (this.otherTime == null) this.otherTime = new HashMap<>();
        this.otherTime.put(sign, time);
        return this;
    }

    /**
     * @description: 添加其他价格
     **/
    public DSpecificationV4 putOtherPrice(String sign, DPrice price) {
        if (this.otherPrices == null) this.otherPrices = new HashMap<>();
        this.otherPrices.put(sign, price);
        return this;
    }

    /**
     * @description: 添加文本
     **/
    public DSpecificationV4 addTexts(String... texts) {
        if (this.texts == null) this.texts = new ArrayList<>();
        if (texts != null && texts.length != 0) {
            this.texts.addAll(Arrays.asList(texts));
        }
        return this;
    }

    /**
     * @description: 添加其他文本
     **/
    @SuppressWarnings("all")
    public DSpecificationV4 putText(String sign, String... texts) {
        if (this.otherTexts == null) this.otherTexts = new HashMap<>();
        if (texts != null) {
            List<String> textList = this.otherTexts.get(sign);
            if (textList == null) {
                textList = new ArrayList<>();
                this.otherTexts.put(sign, textList);
            }
            textList.addAll(Arrays.asList(texts));
        }
        return this;
    }

    /**
     * @description: 添加其余信息
     **/
    public DSpecificationV4 putOther(String key, Object val) {
        if (this.others == null) this.others = new HashMap<>();
        this.others.put(key, val);
        return this;
    }
}
