package com.jhscale.common.model.device.plu.module;

import com.jhscale.common.annotation.DataClass;
import com.jhscale.common.annotation.PublicField;
import com.jhscale.common.model.simple.FieldModel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

import static com.jhscale.common.model.device.DConstant.*;

/**
 * @author lie_w
 * @title: DTime
 * @projectName common
 * @description: 时间信息
 * @date 2022/7/1613:37
 */
// @ApiModel("文本参数V1")
@DataClass(separator = PUBLIC_FIELD_SPLIT_1)
public class DTextV1 extends FieldModel {

    // @ApiModelProperty(value = "文本参数", name = "texts")
    @PublicField(index = 1, type = LST, list_type = TXT,
            set_split = PUBLIC_SET_FIELD_SPLIT_1)
    private List<String> texts;

    public List<String> getTexts() {
        return texts;
    }

    public DTextV1 setTexts(List<String> texts) {
        this.texts = texts;
        return this;
    }

    /**
     * @description: 添加文本
     **/
    public DTextV1 addTexts(String... texts) {
        if (this.texts == null) this.texts = new ArrayList<>();
        if (texts != null)
            this.texts.addAll(Arrays.asList(texts));
        return this;
    }

    /**
     * @description: 获取下坐标文本字段
     **/
    public String text(Integer index) {
        return Objects.nonNull(this.texts) && this.texts.size() > index ? this.texts.get(index) : "";
    }
}
