package com.jhscale.common.model.device.plu.module;

import com.jhscale.common.annotation.DataClass;
import com.jhscale.common.annotation.PublicField;
import com.jhscale.common.model.device._inner.PublicUnPackage;
import com.jhscale.common.model.device._inner.PublicUnPackageArray;
import com.jhscale.common.model.simple.FieldModel;
import org.apache.commons.lang3.StringUtils;

import java.util.Objects;

import static com.jhscale.common.model.device.DConstant.INT;
import static com.jhscale.common.model.device.DConstant.PUBLIC_FIELD_SPLIT_1;

/**
 * @author lie_w
 * @title: DTime
 * @projectName common
 * @description: 时间信息
 * @date 2022/7/1613:37
 */
// @ApiModel("时间格式V2")
@DataClass(separator = PUBLIC_FIELD_SPLIT_1)
public class DTimeV2 extends FieldModel {

    /*******************************使用 出售 日期*************************************/
    // @ApiModelProperty(value = "打印 使用日期", name = "useDatePS")
    @PublicField(index = 5, type = INT)
    private Integer useDatePS;

    // @ApiModelProperty(value = "使用日期", name = "useDatePC")
    @PublicField(index = 10, type = INT)
    private Integer useDatePC;
    /*******************************使用 出售 日期*************************************/


    /*******************************销售 日期 时间*************************************/
    // @ApiModelProperty(value = "打印 销售日期", name = "saleDatePS")
    @PublicField(index = 1, type = INT)
    private Integer saleDatePS;

    // @ApiModelProperty(value = "销售日期", name = "saleDatePC")
    @PublicField(index = 6, type = INT)
    private Integer saleDatePC;


    // @ApiModelProperty(value = "打印 销售时间", name = "saleTimePS")
    @PublicField(index = 2, type = INT)
    private Integer saleTimePS;

    // @ApiModelProperty(value = "销售时间", name = "saleTimePC")
    @PublicField(index = 7, type = INT)
    private Integer saleTimePC;
    /*******************************销售 日期 时间*************************************/


    /*******************************包装 日期 时间*************************************/
    // @ApiModelProperty(value = "打印 包装日期", name = "packDatePS")
    @PublicField(index = 3, type = INT)
    private Integer packDatePS;

    // @ApiModelProperty(value = "包装日期", name = "packDatePC")
    @PublicField(index = 8, type = INT)
    private Integer packDatePC;


    // @ApiModelProperty(value = "打印 包装时间", name = "packTimePS")
    @PublicField(index = 4, type = INT)
    private Integer packTimePS;

    // @ApiModelProperty(value = "包装时间", name = "packTimePC")
    @PublicField(index = 9, type = INT)
    private Integer packTimePC;
    /*******************************包装 日期 时间*************************************/

    /*******************************默认值Get 方法*************************************/

    public Integer useDatePS() {
        return Objects.nonNull(this.useDatePS) ? this.useDatePS : 0;
    }

    public Integer useDatePC() {
        return Objects.nonNull(this.useDatePC) ? this.useDatePC : 0;
    }

    public Integer saleDatePS() {
        return Objects.nonNull(this.saleDatePS) ? this.saleDatePS : 0;
    }

    public Integer saleDatePC() {
        return Objects.nonNull(this.saleDatePC) ? this.saleDatePC : 0;
    }

    public Integer saleTimePS() {
        return Objects.nonNull(this.saleTimePS) ? this.saleTimePS : 0;
    }

    public Integer saleTimePC() {
        return Objects.nonNull(this.saleTimePC) ? this.saleTimePC : 0;
    }

    public Integer packDatePS() {
        return Objects.nonNull(this.packDatePS) ? this.packDatePS : 0;
    }

    public Integer packDatePC() {
        return Objects.nonNull(this.packDatePC) ? this.packDatePC : 0;
    }

    public Integer packTimePS() {
        return Objects.nonNull(this.packTimePS) ? this.packTimePS : 0;
    }

    public Integer packTimePC() {
        return Objects.nonNull(this.packTimePC) ? this.packTimePC : 0;
    }

    /**
     * @param contents
     * @param serial
     * @description: 默认拆解方法1
     */
    @Override
    public PublicUnPackage un_package_method(String[] contents, int serial) {
        PublicUnPackage unPackage = new PublicUnPackage(contents);
        try {
            switch (serial) {
                case 0:
                    unPackage = this.contents_copyOfRange(unPackage.getSurplusContents(), 1);
                    String[] contents_0 = ((PublicUnPackageArray) unPackage).getContents();
                    Integer useDatePC = StringUtils.isBlank(contents_0[0]) ? 0 : Integer.parseInt(contents_0[0]);
                    this.setUseDatePC(useDatePC);
                    this.setUseDatePS(useDatePC > 0 ? 1 : 0);
                    break;
            }
        } catch (Exception e) {
        }
        return unPackage;
    }

    /*******************************默认值Get 方法*************************************/


    public Integer getUseDatePS() {
        return useDatePS;
    }

    public DTimeV2 setUseDatePS(Integer useDatePS) {
        this.useDatePS = useDatePS;
        return this;
    }

    public Integer getUseDatePC() {
        return useDatePC;
    }

    public DTimeV2 setUseDatePC(Integer useDatePC) {
        this.useDatePC = useDatePC;
        return this;
    }

    public Integer getSaleDatePS() {
        return saleDatePS;
    }

    public DTimeV2 setSaleDatePS(Integer saleDatePS) {
        this.saleDatePS = saleDatePS;
        return this;
    }

    public Integer getSaleDatePC() {
        return saleDatePC;
    }

    public DTimeV2 setSaleDatePC(Integer saleDatePC) {
        this.saleDatePC = saleDatePC;
        return this;
    }

    public Integer getSaleTimePS() {
        return saleTimePS;
    }

    public DTimeV2 setSaleTimePS(Integer saleTimePS) {
        this.saleTimePS = saleTimePS;
        return this;
    }

    public Integer getSaleTimePC() {
        return saleTimePC;
    }

    public DTimeV2 setSaleTimePC(Integer saleTimePC) {
        this.saleTimePC = saleTimePC;
        return this;
    }

    public Integer getPackDatePS() {
        return packDatePS;
    }

    public DTimeV2 setPackDatePS(Integer packDatePS) {
        this.packDatePS = packDatePS;
        return this;
    }

    public Integer getPackDatePC() {
        return packDatePC;
    }

    public DTimeV2 setPackDatePC(Integer packDatePC) {
        this.packDatePC = packDatePC;
        return this;
    }

    public Integer getPackTimePS() {
        return packTimePS;
    }

    public DTimeV2 setPackTimePS(Integer packTimePS) {
        this.packTimePS = packTimePS;
        return this;
    }

    public Integer getPackTimePC() {
        return packTimePC;
    }

    public DTimeV2 setPackTimePC(Integer packTimePC) {
        this.packTimePC = packTimePC;
        return this;
    }

}
