package com.jhscale.common.model.device.plu.param;

import java.util.Objects;

/**
 * @author lie_w
 * @title: CategoryType
 * @projectName common
 * @description: 种类类型
 * @date 2022/7/1622:39
 */
public enum CategoryType {

    普通分类(0, "普通分类"),
    快捷分类(1, "快捷分类");

    private Integer type;

    private String description;

    CategoryType(Integer type, String description) {
        this.type = type;
        this.description = description;
    }

    /**
     * @description: 获取枚举
     **/
    public static CategoryType type(Integer type) {
        if (Objects.nonNull(type)) {
            for (CategoryType categoryType : CategoryType.values()) {
                if (type.equals(categoryType.getType())) return categoryType;
            }
        }
        return CategoryType.普通分类;
    }

    public Integer getType() {
        return type;
    }

    public String getDescription() {
        return description;
    }

}
