package com.jhscale.common.model.device.plu.param;

import java.math.BigDecimal;

/**
 * @author lie_w
 * @title: DAutoDiscountConstant
 * @projectName common
 * @description: TODO
 * @date 2022/7/1617:35
 */
public interface DAutoDiscountConstant {

    /**
     * @description: 自动折扣类型
     * 0-不激活
     * 1-数量/重量折扣
     * 2-时间折扣
     * 3-单计禁售-1
     * 4-会员A类折扣
     * 5-会员B类折扣
     * 6-会员C类折扣
     * 7-会员D类折扣
     * 8-数量/重量禁售-1
     * 9-数量/重量禁售-2
     * 10-单计禁售-2
     **/
    Integer AUTO_DISCOUNT_TYPE0 = 0;
    Integer AUTO_DISCOUNT_TYPE1 = 1;
    Integer AUTO_DISCOUNT_TYPE2 = 2;
    Integer AUTO_DISCOUNT_TYPE3 = 3;
    Integer AUTO_DISCOUNT_TYPE4 = 4;
    Integer AUTO_DISCOUNT_TYPE5 = 5;
    Integer AUTO_DISCOUNT_TYPE6 = 6;
    Integer AUTO_DISCOUNT_TYPE7 = 7;
    Integer AUTO_DISCOUNT_TYPE8 = 8;
    Integer AUTO_DISCOUNT_TYPE9 = 9;
    Integer AUTO_DISCOUNT_TYPE10 = 10;

    /**
     * @description: 激活日
     **/
    Integer NOD = 0;
    Integer SUN = 1;
    Integer MON = 2;
    Integer TUES = 4;
    Integer WED = 8;
    Integer THUR = 16;
    Integer FRI = 32;
    Integer SAT = 64;

    /**
     * @description: 区间值
     **/
    BigDecimal DEFAULT_VAL = new BigDecimal("0.00");

    /**
     * @description: 折扣值
     **/
    BigDecimal DEFAULT_DISCOUNT_VAL = new BigDecimal("0.00");

    /**
     * @description: 区间类型
     **/
    Integer INNER = 0;
    Integer OUTER = 1;
}
