package com.jhscale.common.model.device.plu.param;

import java.math.BigDecimal;

/**
 * @author lie_w
 * @title: DManualDiscountConstant
 * @projectName common
 * @description: 手动折扣参数
 * @date 2022/7/1617:26
 */
public interface DManualDiscountConstant {

    /**
     * @description: 上下限
     **/
    Integer UPPER = 0;
    Integer LOWER = 1;


    /**
     * @description: 手动折扣类型
     * 0 ：使用系统设定， 1：无上限 2： 以原始单价为上限 3：已设定数字为上限
     **/
    Integer DISCOUNT1 = 0;
    Integer DISCOUNT2 = 1;
    Integer DISCOUNT3 = 2;
    Integer DISCOUNT4 = 3;

    /**
     * @description: 折扣值
     **/
    BigDecimal DEFAULT_DISCOUNT_VAL = new BigDecimal("0.00");

}
