package com.jhscale.common.model.device.plu.param;

import org.apache.commons.lang3.StringUtils;

/**
 * @author lie_w
 * @title: PLUState
 * @projectName common
 * @description: TODO
 * @date 2022/7/1621:25
 */
public enum PLUState {

    未知("0", "未知"),
    下架("1", "下架"),
    正常("2", "正常"),
    停售("3", "停售"),
    缺货("4", "缺货"),
    库存紧张("5", "库存紧张");

    private String state;

    private String description;

    PLUState(String state, String description) {
        this.state = state;
        this.description = description;
    }

    /**
     * @description: 获取枚举
     **/
    public static PLUState state(String state) {
        if (StringUtils.isNotBlank(state)) {
            for (PLUState pluState : PLUState.values()) {
                if (state.equalsIgnoreCase(pluState.getState())) return pluState;
            }
        }
        return PLUState.未知;
    }

    public Integer state() {
        return Integer.parseInt(this.state);
    }

    public String getState() {
        return state;
    }

    public String getDescription() {
        return description;
    }
}
