package com.jhscale.common.model.device.plu.param;

import org.apache.commons.lang3.StringUtils;

/**
 * @author lie_w
 * @title: PLUType
 * @projectName common
 * @description: TODO
 * @date 2022/7/1621:32
 */
public enum PLUType {

    普通商品("0", "普通商品"),
    AI商品("1", "AI商品 (训练过的商品)"),
    AI训练商品("2", "AI待训练商品(用户创建商品)");

    private String type;

    private String description;

    PLUType(String type, String description) {
        this.type = type;
        this.description = description;
    }

    /**
     * @description: 获取枚举
     **/
    public static PLUType type(String type) {
        if (StringUtils.isNotBlank(type)) {
            for (PLUType pluType : PLUType.values()) {
                if (type.equalsIgnoreCase(pluType.getType())) return pluType;
            }
        }
        return PLUType.普通商品;
    }

    public String getType() {
        return type;
    }

    public String getDescription() {
        return description;
    }
}
