package com.jhscale.common.model.device.polymerization.cloudpay;

import com.jhscale.common.model.device.polymerization.inner.AggregatedEntity;
import com.jhscale.common.model.device.polymerization.inner.AggregatedMark;
import com.jhscale.common.model.device.polymerization.inner.RXTXData;
import com.jhscale.common.utils.ByteUtils;

/**
 * @author wang lie
 * @version 1.0
 * @projectName common
 * @title CancelPaymentTX
 * @description 结束订单
 * @create 2024/1/23 11:01
 */
public class EndPaymentRequest extends AggregatedEntity {

    // 1. 操作 0-取消订单 1-撤销订单 2-关闭订单
    private int end;

    // 2. 三方支付单号 [设备记录编号|系统支付单号|三方支付单号 三选一] 4字节
    private int fid;

    // 3. 三方支付单号 [设备记录编号|系统支付单号|三方支付单号 三选一]
    private String orderno;

    // 4. 三方支付单号 [设备记录编号|系统支付单号|三方支付单号 三选一]
    private String tradeno;

    public EndPaymentRequest() {
        super(new AggregatedMark(true, true));
    }

    public EndPaymentRequest(RXTXData rxtxData) {
        super(rxtxData);
    }

    /**
     * @description: 内包组装
     **/
    @Override
    public StringBuilder inner_assembly() {
        return new StringBuilder()
                .append(ByteUtils.int2Hex(this.end))
                .append(ByteUtils.int2HexWithPush(this.fid, 8))
                .append(ByteUtils.a_text(this.orderno))
                .append(ByteUtils.a_text(this.tradeno));
    }

    /**
     * @param innerContent
     * @description: 内包解析
     */
    @Override
    public String inner_analyse(String innerContent) {
        this.end = ByteUtils.hex2Ten(innerContent.substring(0, 2));
        innerContent = innerContent.substring(2);

        this.fid = ByteUtils.hex2Ten(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);

        int index = ByteUtils.indexOf(innerContent, "00");
        if (index != -1) {
            this.orderno = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }

        index = ByteUtils.indexOf(innerContent, "00");
        if (index != -1) {
            this.tradeno = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }
        return innerContent;
    }

    public int getEnd() {
        return end;
    }

    public void setEnd(int end) {
        this.end = end;
    }

    public int getFid() {
        return fid;
    }

    public void setFid(int fid) {
        this.fid = fid;
    }

    public String getOrderno() {
        return orderno;
    }

    public void setOrderno(String orderno) {
        this.orderno = orderno;
    }

    public String getTradeno() {
        return tradeno;
    }

    public void setTradeno(String tradeno) {
        this.tradeno = tradeno;
    }

    public String fid() {
        return ByteUtils.fid(this.fid);
    }
}
