package com.jhscale.common.model.device.polymerization.cloudpay;

import com.jhscale.common.model.device.polymerization.inner.AggregatedEntity;
import com.jhscale.common.model.device.polymerization.inner.AggregatedMark;
import com.jhscale.common.model.device.polymerization.inner.RXTXData;
import com.jhscale.common.utils.ByteUtils;
import com.jhscale.common.utils.RandomUtils;

import java.math.BigDecimal;

/**
 * @author wang lie
 * @version 1.0
 * @projectName common
 * @title PretreatmentPaymentRequest
 * @description 支付请求
 * @create 2024/1/22 13:08
 */
public class PaymentRequest extends AggregatedEntity {

    // 1. FID 4字节
    private int fid;

    // 2. 金额 特殊浮点
    private BigDecimal amount;

    // 3. 随机字节 2字节
    private int random = RandomUtils.integer_random(65535);

    // 4. 标题 交易累计中，第一个商品的商品名
    private String title;

    // 5. 明细数量 1字节
    private int count;

    public PaymentRequest() {
        super(new AggregatedMark(true, true));
    }

    public PaymentRequest(RXTXData rxtxData) {
        super(rxtxData);
    }

    /**
     * @description: 内包组装
     **/
    @Override
    public StringBuilder inner_assembly() {
        return new StringBuilder()
                .append(ByteUtils.int2HexWithPush(this.fid, 8))
                .append(ByteUtils.toSPFStrNone(this.amount))
                .append(ByteUtils.int2HexWithPush(this.random, 4))
                .append(ByteUtils.a_text(this.title))
                .append(ByteUtils.int2Hex(this.count));
    }

    /**
     * @return
     * @description: 内包解析
     */
    @Override
    public String inner_analyse(String innerContent) {
        this.fid = ByteUtils.hex2Ten(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);

        this.amount = ByteUtils.convertBigDecimalNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);

        this.random = ByteUtils.hex2Ten(innerContent.substring(0, 4));
        innerContent = innerContent.substring(4);

        int index = ByteUtils.indexOf(innerContent, "00");
        if (index != -1) {
            this.title = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }

        this.count = ByteUtils.hex2Ten(innerContent.substring(0, 2));
        innerContent = innerContent.substring(2);

        return innerContent;
    }

    public int getFid() {
        return fid;
    }

    public void setFid(int fid) {
        this.fid = fid;
    }

    public BigDecimal getAmount() {
        return amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public int getRandom() {
        return random;
    }

    public void setRandom(int random) {
        this.random = random;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public int getCount() {
        return count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public String fid() {
        return ByteUtils.fid(this.fid);
    }
}
