package com.jhscale.common.model.device.polymerization.cloudpay;

import com.jhscale.common.model.device.polymerization.inner.AggregatedEntity;
import com.jhscale.common.model.device.polymerization.inner.AggregatedMark;
import com.jhscale.common.model.device.polymerization.inner.RXTXData;
import com.jhscale.common.utils.ByteUtils;

import java.math.BigDecimal;

/**
 * @author wang lie
 * @version 1.0
 * @projectName common
 * @title PaymentResponse
 * @description 支付响应
 * @create 2024/1/23 8:46
 */
public class PaymentResponse extends AggregatedEntity {

    // 1. 状态码 HandleState
    private int code;

    // 2. FID 4字节
    private int fid;

    // 3. 订单金额 特殊浮点
    private BigDecimal amount;

    // 4. 标题
    private String title;

    // 5. 系统支付订单号
    private String orderno;

    // 6. 支付渠道 1-支付宝|2-微信|70-云闪付|71-沈阳建行|72-上海邮政
    private int payway;

    // 7. 支付类型 1-支付宝|2-微信|70-云闪付|71-龙支付
    private int paytype;

    // 8. 订单备注信息
    private String remark;

    // 9. 订单响应信息
    private String payinfo;

    public PaymentResponse() {
        super(new AggregatedMark(true, false));
    }

    public PaymentResponse(RXTXData rxtxData) {
        super(rxtxData);
    }

    /**
     * @description: 内包组装
     **/
    @Override
    public StringBuilder inner_assembly() {
        return new StringBuilder()
                .append(ByteUtils.int2HexWithPush(this.code, 4))
                .append(ByteUtils.int2HexWithPush(this.fid, 8))
                .append(ByteUtils.toSPFStrNone(this.amount))
                .append(ByteUtils.a_text(this.title))
                .append(ByteUtils.a_text(this.orderno))
                .append(ByteUtils.int2Hex(this.payway))
                .append(ByteUtils.int2Hex(this.paytype))
                .append(ByteUtils.a_text(this.remark))
                .append(ByteUtils.a_text(this.payinfo));
    }

    /**
     * @param innerContent
     * @return
     * @description: 内包解析
     */
    @Override
    public String inner_analyse(String innerContent) {
        this.code = ByteUtils.hex2Ten(innerContent.substring(0, 4));
        innerContent = innerContent.substring(4);

        this.fid = ByteUtils.hex2Ten(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);

        this.amount = ByteUtils.convertBigDecimalNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);

        int index = ByteUtils.indexOf(innerContent, "00");
        if (index != -1) {
            this.title = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }

        index = ByteUtils.indexOf(innerContent, "00");
        if (index != -1) {
            this.orderno = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }

        this.payway = ByteUtils.hex2Ten(innerContent.substring(0, 2));
        innerContent = innerContent.substring(2);

        this.paytype = ByteUtils.hex2Ten(innerContent.substring(0, 2));
        innerContent = innerContent.substring(2);

        index = ByteUtils.indexOf(innerContent, "00");
        if (index != -1) {
            this.remark = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }

        index = ByteUtils.indexOf(innerContent, "00");
        if (index != -1) {
            this.payinfo = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }
        return innerContent;
    }

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public int getFid() {
        return fid;
    }

    public void setFid(int fid) {
        this.fid = fid;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getOrderno() {
        return orderno;
    }

    public void setOrderno(String orderno) {
        this.orderno = orderno;
    }

    public int getPayway() {
        return payway;
    }

    public void setPayway(int payway) {
        this.payway = payway;
    }

    public int getPaytype() {
        return paytype;
    }

    public void setPaytype(int paytype) {
        this.paytype = paytype;
    }

    public BigDecimal getAmount() {
        return amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getPayinfo() {
        return payinfo;
    }

    public void setPayinfo(String payinfo) {
        this.payinfo = payinfo;
    }

    public String fid() {
        return ByteUtils.fid(this.fid);
    }
}
