package com.jhscale.common.model.device.polymerization.cloudpay;

import com.jhscale.common.model.device.polymerization.inner.AggregatedEntity;
import com.jhscale.common.model.device.polymerization.inner.AggregatedMark;
import com.jhscale.common.model.device.polymerization.inner.RXTXData;
import com.jhscale.common.utils.ByteUtils;

/**
 * @author wang lie
 * @version 1.0
 * @projectName common
 * @title PretreatmentPaymentRequest
 * @description
 * @create 2024/2/15 9:11
 */
public class PretreatmentPaymentRequest extends AggregatedEntity {

    // 1. FID 4字节
    private int fid;

    // 2. 系统订单号
    private String orderno;

    // 3. 订单备注信息
    private String remark;

    // 4. 付款码支付
    private String auth;

    // 5. 重发序号 1字节
    private int retryCount;

    public PretreatmentPaymentRequest() {
        super(new AggregatedMark(true, true));
    }

    public PretreatmentPaymentRequest(RXTXData rxtxData) {
        super(rxtxData);
    }

    /**
     * @description: 内包组装
     **/
    @Override
    public StringBuilder inner_assembly() {
        return super.inner_assembly()
                .append(ByteUtils.int2HexWithPush(this.fid, 8))
                .append(ByteUtils.a_text(this.orderno))
                .append(ByteUtils.a_text(this.remark))
                .append(ByteUtils.a_text(this.auth))
                .append(ByteUtils.int2Hex(this.retryCount));
    }

    /**
     * @param innerContent
     * @description: 内包解析
     */
    @Override
    public String inner_analyse(String innerContent) {
        this.fid = ByteUtils.hex2Ten(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);

        int index = ByteUtils.indexOf(innerContent, "00");
        if (index != -1) {
            this.orderno = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }

        index = ByteUtils.indexOf(innerContent, "00");
        if (index != -1) {
            this.remark = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }

        index = ByteUtils.indexOf(innerContent, "00");
        if (index != -1) {
            this.auth = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }

        this.retryCount = ByteUtils.hex2Ten(innerContent.substring(0, 2));
        innerContent = innerContent.substring(2);

        return innerContent;
    }

    public int getFid() {
        return fid;
    }

    public void setFid(int fid) {
        this.fid = fid;
    }

    public String getOrderno() {
        return orderno;
    }

    public void setOrderno(String orderno) {
        this.orderno = orderno;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getAuth() {
        return auth;
    }

    public void setAuth(String auth) {
        this.auth = auth;
    }

    public int getRetryCount() {
        return retryCount;
    }

    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }

    public String fid() {
        return ByteUtils.fid(this.fid);
    }
}
