package com.jhscale.common.model.device.polymerization.cloudpay;

import com.jhscale.common.model.device.polymerization.inner.RXTXData;
import com.jhscale.common.utils.ByteUtils;

/**
 * @author wang lie
 * @version 1.0
 * @projectName common
 * @title PretreatmentPaymentRX
 * @description 预创建响应
 * @create 2024/1/23 9:55
 */
public class PretreatmentPaymentResponse extends ResultPaymentResponse {

    // 10. 支付二维码状态
    private int qrstate;

    // 10. 被扫支付付款二维码
    private String sysPayUrl;

    public PretreatmentPaymentResponse() {
    }

    public PretreatmentPaymentResponse(RXTXData rxtxData) {
        super(rxtxData);
    }

    /**
     * @description: 内包组装
     **/
    @Override
    public StringBuilder inner_assembly() {
        return super.inner_assembly()
                .append(ByteUtils.int2Hex(this.qrstate))
                .append(ByteUtils.a_text(this.sysPayUrl));
    }

    /**
     * @param innerContent
     * @return
     * @description: 内包解析
     */
    @Override
    public String inner_analyse(String innerContent) {
        innerContent = super.inner_analyse(innerContent);

        this.qrstate = ByteUtils.hex2Ten(innerContent.substring(0, 2));
        innerContent = innerContent.substring(2);

        int index = ByteUtils.indexOf(innerContent, "00");
        if (index != -1) {
            this.sysPayUrl = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }
        return innerContent;
    }

    public int getQrstate() {
        return qrstate;
    }

    public void setQrstate(int qrstate) {
        this.qrstate = qrstate;
    }

    public String getSysPayUrl() {
        return sysPayUrl;
    }

    public void setSysPayUrl(String sysPayUrl) {
        this.sysPayUrl = sysPayUrl;
    }
}
