package com.jhscale.common.model.device.polymerization.cloudpay;

import com.jhscale.common.model.device.polymerization.inner.AggregatedEntity;
import com.jhscale.common.model.device.polymerization.inner.AggregatedMark;
import com.jhscale.common.model.device.polymerization.inner.RXTXData;
import com.jhscale.common.utils.ByteUtils;

/**
 * @author wang lie
 * @version 1.0
 * @projectName common
 * @title QueryPaymentTX
 * @description 退款查询
 * @create 2024/1/23 10:47
 */
public class RefundQueryRequest extends AggregatedEntity {

    // 1. 插叙方式 0-本地查询 1-第三方查询 1字节
    private int query;

    // 2. 设备记录编号 [设备记录编号|系统支付单号|三方支付单号 三选一] 4字节
    private int fid;

    // 3. 系统支付单号 [设备记录编号|系统支付单号|三方支付单号 三选一]
    private String refundno;

    // 4. 三方支付单号 [设备记录编号|系统支付单号|三方支付单号 三选一]
    private String retrunno;

    public RefundQueryRequest() {
        super(new AggregatedMark(true, true));
    }

    public RefundQueryRequest(RXTXData rxtxData) {
        super(rxtxData);
    }

    /**
     * @description: 内包组装
     **/
    @Override
    public StringBuilder inner_assembly() {
        return new StringBuilder()
                .append(ByteUtils.int2Hex(this.query))
                .append(ByteUtils.int2HexWithPush(this.fid, 8))
                .append(ByteUtils.a_text(this.refundno))
                .append(ByteUtils.a_text(this.retrunno));
    }

    /**
     * @param innerContent
     * @description: 内包解析
     */
    @Override
    public String inner_analyse(String innerContent) {
        this.query = ByteUtils.hex2Ten(innerContent.substring(0, 2));
        innerContent = innerContent.substring(2);

        this.fid = ByteUtils.hex2Ten(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);

        int index = ByteUtils.indexOf(innerContent, "00");
        if (index != -1) {
            this.refundno = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }

        index = ByteUtils.indexOf(innerContent, "00");
        if (index != -1) {
            this.retrunno = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }
        return innerContent;
    }

    public int getQuery() {
        return query;
    }

    public void setQuery(int query) {
        this.query = query;
    }

    public int getFid() {
        return fid;
    }

    public void setFid(int fid) {
        this.fid = fid;
    }

    public String getRefundno() {
        return refundno;
    }

    public void setRefundno(String refundno) {
        this.refundno = refundno;
    }

    public String getRetrunno() {
        return retrunno;
    }

    public void setRetrunno(String retrunno) {
        this.retrunno = retrunno;
    }

    public String fid() {
        return ByteUtils.fid(this.fid);
    }
}
