package com.jhscale.common.model.device.polymerization.cloudpay;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.jhscale.common.model.device.polymerization.inner.AggregatedEntity;
import com.jhscale.common.model.device.polymerization.inner.AggregatedMark;
import com.jhscale.common.model.device.polymerization.inner.RXTXData;
import com.jhscale.common.utils.ByteUtils;
import com.jhscale.common.utils.RandomUtils;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author wang lie
 * @version 1.0
 * @projectName common
 * @title PretreatmentPaymentRequest
 * @description 退款请求
 * @create 2024/1/22 13:08
 */
public class RefundRequest extends AggregatedEntity {

    // 1. FID 4字节 设备Fid
    private int balanceId;

    // 1. FID 4字节 Fid 订单编号不能同时为空
    private int orderFid;

    // 2. 订单编号
    private String orderNo;

    // 3. 交易时间
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date orderTime;

    // 4. 退款日志Fid（不传默认订单Fid）
    private int fid;

    // 5. 退款日志Sid（不传默认订单Sid）
    private int sid;

    // 6. 操作人员
    private int scaleMan;

    // 7. 退款金额 特殊浮点[不传默认全部]
    private BigDecimal amount;

    // 8. 随机字节 2字节
    private int random = RandomUtils.integer_random(65535);

    // 9. 备注
    private String remark;

    // 10 自动生成退货日志 0-非自动 1-自动
    private int autoLog;

    public RefundRequest() {
        super(new AggregatedMark(true, true));
    }

    public RefundRequest(RXTXData rxtxData) {
        super(rxtxData);
    }

    /**
     * @description: 内包组装
     **/
    @Override
    public StringBuilder inner_assembly() {
        return new StringBuilder()
                .append(ByteUtils.fid(this.balanceId))
                .append(ByteUtils.fid(this.orderFid))
                .append(ByteUtils.a_text(this.orderNo))
                .append(ByteUtils.timeToStrNone(this.orderTime))
                .append(ByteUtils.fid(this.fid))
                .append(ByteUtils.fid(this.sid))
                .append(ByteUtils.int2Hex(this.scaleMan))
                .append(ByteUtils.toSPFStrNone(this.amount))
                .append(ByteUtils.int2HexWithPush(this.random, 4))
                .append(ByteUtils.a_text(this.remark))
                .append(ByteUtils.int2Hex(this.autoLog));
    }

    /**
     * @return
     * @description: 内包解析
     */
    @Override
    public String inner_analyse(String innerContent) {
        this.balanceId = ByteUtils.hex2Ten(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);

        this.orderFid = ByteUtils.hex2Ten(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);

        int index = ByteUtils.indexOf(innerContent, "00");
        if (index != -1) {
            this.orderNo = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }

        this.orderTime = ByteUtils.convertTimeNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);

        this.fid = ByteUtils.hex2Ten(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);

        this.sid = ByteUtils.hex2Ten(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);

        this.scaleMan = ByteUtils.hex2Ten(innerContent.substring(0, 2));
        innerContent = innerContent.substring(2);

        this.amount = ByteUtils.convertBigDecimalNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);

        this.random = ByteUtils.hex2Ten(innerContent.substring(0, 4));
        innerContent = innerContent.substring(4);

        index = ByteUtils.indexOf(innerContent, "00");
        if (index != -1) {
            this.remark = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }

        this.autoLog = ByteUtils.hex2Ten(innerContent.substring(0, 2));
        innerContent = innerContent.substring(2);
        return innerContent;
    }

    public int getBalanceId() {
        return balanceId;
    }

    public void setBalanceId(int balanceId) {
        this.balanceId = balanceId;
    }

    public int getOrderFid() {
        return orderFid;
    }

    public void setOrderFid(int orderFid) {
        this.orderFid = orderFid;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public Date getOrderTime() {
        return orderTime;
    }

    public void setOrderTime(Date orderTime) {
        this.orderTime = orderTime;
    }

    public int getFid() {
        return fid;
    }

    public void setFid(int fid) {
        this.fid = fid;
    }

    public int getSid() {
        return sid;
    }

    public void setSid(int sid) {
        this.sid = sid;
    }

    public int getScaleMan() {
        return scaleMan;
    }

    public void setScaleMan(int scaleMan) {
        this.scaleMan = scaleMan;
    }

    public BigDecimal getAmount() {
        return amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public int getRandom() {
        return random;
    }

    public void setRandom(int random) {
        this.random = random;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String orderFid() {
        return ByteUtils.fid(this.orderFid);
    }

    public int getAutoLog() {
        return autoLog;
    }

    public void setAutoLog(int autoLog) {
        this.autoLog = autoLog;
    }
}
