package com.jhscale.common.model.device.polymerization.cloudpay;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.jhscale.common.model.device.polymerization.inner.AggregatedEntity;
import com.jhscale.common.model.device.polymerization.inner.AggregatedMark;
import com.jhscale.common.model.device.polymerization.inner.RXTXData;
import com.jhscale.common.utils.ByteUtils;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author wang lie
 * @version 1.0
 * @projectName common
 * @title PaymentResponse
 * @description 退款响应
 * @create 2024/1/23 8:46
 */
public class RefundResponse extends AggregatedEntity {

    // 1. 状态码 HandleState
    private int code;

    // 2. FID 4字节
    private int fid;

    // 3. 订单金额 特殊浮点
    private BigDecimal amount;

    // 4. 系统订单号
    private String orderno;

    // 5. 系统退款订单号
    private String refundno;

    // 6. 三方退款订单号
    private String retrunno;

    // 7. 支付渠道 1-支付宝|2-微信|70-云闪付|71-沈阳建行|72-上海邮政
    private int payway;

    // 8. 订单备注信息
    private String remark;

    // 9. 完成时间
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date expire;

    // 10. 错误码
    private String errCode;

    // 11. 错误信息
    private String errMsg;

    public RefundResponse() {
        super(new AggregatedMark(true, false));
    }

    public RefundResponse(RXTXData rxtxData) {
        super(rxtxData);
    }

    /**
     * @description: 内包组装
     **/
    @Override
    public StringBuilder inner_assembly() {
        return new StringBuilder()
                .append(ByteUtils.int2HexWithPush(this.code, 4))
                .append(ByteUtils.int2HexWithPush(this.fid, 8))
                .append(ByteUtils.toSPFStrNone(this.amount))
                .append(ByteUtils.a_text(this.orderno))
                .append(ByteUtils.a_text(this.refundno))
                .append(ByteUtils.a_text(this.retrunno))
                .append(ByteUtils.int2Hex(this.payway))
                .append(ByteUtils.a_text(this.remark))
                .append(ByteUtils.timeToStrNone(this.expire))
                .append(ByteUtils.a_text(this.errCode))
                .append(ByteUtils.a_text(this.errMsg));
    }

    /**
     * @param innerContent
     * @return
     * @description: 内包解析
     */
    @Override
    public String inner_analyse(String innerContent) {
        this.code = ByteUtils.hex2Ten(innerContent.substring(0, 4));
        innerContent = innerContent.substring(4);

        this.fid = ByteUtils.hex2Ten(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);

        this.amount = ByteUtils.convertBigDecimalNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);

        int index = ByteUtils.indexOf(innerContent, "00");
        if (index != -1) {
            this.orderno = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }

        index = ByteUtils.indexOf(innerContent, "00");
        if (index != -1) {
            this.refundno = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }

        index = ByteUtils.indexOf(innerContent, "00");
        if (index != -1) {
            this.retrunno = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }

        this.payway = ByteUtils.hex2Ten(innerContent.substring(0, 2));
        innerContent = innerContent.substring(2);

        index = ByteUtils.indexOf(innerContent, "00");
        if (index != -1) {
            this.remark = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }

        this.expire = ByteUtils.convertTimeNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);

        index = ByteUtils.indexOf(innerContent, "00");
        if (index != -1) {
            this.errCode = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }

        index = ByteUtils.indexOf(innerContent, "00");
        if (index != -1) {
            this.errMsg = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }
        return innerContent;
    }

    public String fid() {
        return ByteUtils.fid(this.fid);
    }

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public int getFid() {
        return fid;
    }

    public void setFid(int fid) {
        this.fid = fid;
    }

    public BigDecimal getAmount() {
        return amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public String getOrderno() {
        return orderno;
    }

    public void setOrderno(String orderno) {
        this.orderno = orderno;
    }

    public String getRefundno() {
        return refundno;
    }

    public void setRefundno(String refundno) {
        this.refundno = refundno;
    }

    public String getRetrunno() {
        return retrunno;
    }

    public void setRetrunno(String retrunno) {
        this.retrunno = retrunno;
    }

    public int getPayway() {
        return payway;
    }

    public void setPayway(int payway) {
        this.payway = payway;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Date getExpire() {
        return expire;
    }

    public void setExpire(Date expire) {
        this.expire = expire;
    }

    public String getErrCode() {
        return errCode;
    }

    public void setErrCode(String errCode) {
        this.errCode = errCode;
    }

    public String getErrMsg() {
        return errMsg;
    }

    public void setErrMsg(String errMsg) {
        this.errMsg = errMsg;
    }
}
