
package com.jhscale.common.model.device.polymerization.cloudpay;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.jhscale.common.model.device.polymerization.inner.RXTXData;
import com.jhscale.common.utils.ByteUtils;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author wang lie
 * @version 1.0
 * @projectName common
 * @title PretreatmentPaymentRX
 * @description 预创建响应
 * @create 2024/1/23 9:55
 */
public class ResultPaymentResponse extends PaymentResponse {

    // 10. 错误码
    private String errCode;

    // 11. 错误信息
    private String errMsg;

    // 12. 第三方订单编号
    private String tradeno;

    // 13. 实际支付金额
    private BigDecimal actamount;

    // 14. 完成时间
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date expire;

    public ResultPaymentResponse() {
    }

    public ResultPaymentResponse(RXTXData rxtxData) {
        super(rxtxData);
    }

    /**
     * @description: 内包组装
     **/
    @Override
    public StringBuilder inner_assembly() {
        return super.inner_assembly()
                .append(ByteUtils.a_text(this.errCode))
                .append(ByteUtils.a_text(this.errMsg))
                .append(ByteUtils.a_text(this.tradeno))
                .append(ByteUtils.toSPFStrNone(this.actamount))
                .append(ByteUtils.timeToStrNone(this.expire));
    }

    /**
     * @param innerContent
     * @return
     * @description: 内包解析
     */
    @Override
    public String inner_analyse(String innerContent) {
        innerContent = super.inner_analyse(innerContent);

        int index = ByteUtils.indexOf(innerContent, "00");
        if (index != -1) {
            this.errCode = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }

        index = ByteUtils.indexOf(innerContent, "00");
        if (index != -1) {
            this.errMsg = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }

        index = ByteUtils.indexOf(innerContent, "00");
        if (index != -1) {
            this.tradeno = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }

        this.actamount = ByteUtils.convertBigDecimalNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);

        this.expire = ByteUtils.convertTimeNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);
        return innerContent;
    }

    public String getErrCode() {
        return errCode;
    }

    public void setErrCode(String errCode) {
        this.errCode = errCode;
    }

    public String getErrMsg() {
        return errMsg;
    }

    public void setErrMsg(String errMsg) {
        this.errMsg = errMsg;
    }

    public String getTradeno() {
        return tradeno;
    }

    public void setTradeno(String tradeno) {
        this.tradeno = tradeno;
    }

    public BigDecimal getActamount() {
        return actamount;
    }

    public void setActamount(BigDecimal actamount) {
        this.actamount = actamount;
    }

    public Date getExpire() {
        return expire;
    }

    public void setExpire(Date expire) {
        this.expire = expire;
    }
}
