package com.jhscale.common.model.device.polymerization.cloudpay;

import com.jhscale.common.model.device.polymerization.inner.RXTXData;
import com.jhscale.common.utils.ByteUtils;

/**
 * @author wang lie
 * @version 1.0
 * @projectName common
 * @title ScanPaymentTX
 * @description 主扫请求
 * @create 2024/1/23 10:19
 */
public class ScanPaymentRequest extends PaymentRequest {

    // 6. 重发序号 1字节
    private int retryCount;

    // 7. 授权码
    private String auth;

    public ScanPaymentRequest() {
    }

    public ScanPaymentRequest(RXTXData rxtxData) {
        super(rxtxData);
    }

    /**
     * @description: 内包组装
     **/
    @Override
    public StringBuilder inner_assembly() {
        return super.inner_assembly()
                .append(ByteUtils.int2Hex(this.retryCount))
                .append(ByteUtils.a_text(this.auth));
    }

    /**
     * @param innerContent
     * @return
     * @description: 内包解析
     */
    @Override
    public String inner_analyse(String innerContent) {
        innerContent = super.inner_analyse(innerContent);

        this.retryCount = ByteUtils.hex2Ten(innerContent.substring(0, 2));
        innerContent = innerContent.substring(2);

        int index = ByteUtils.indexOf(innerContent, "00");
        if (index != -1) {
            this.auth = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }
        return innerContent;
    }

    public int getRetryCount() {
        return retryCount;
    }

    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }

    public String getAuth() {
        return auth;
    }

    public void setAuth(String auth) {
        this.auth = auth;
    }
}
