package com.jhscale.common.model.device.polymerization.em;

import org.apache.commons.lang3.StringUtils;

public enum ChannelStatus {

    新码(0, "NEW", TradeCodeRefresh.保持),
    新用户需注册(1, "NEW_CUS", TradeCodeRefresh.保持),
    商户客户检查通过(2, "MU_SUCCESS", TradeCodeRefresh.保持),
    等待输入密码(3, "WAIT_PWD", TradeCodeRefresh.保持),
    输入密码(4, "INPUT", TradeCodeRefresh.保持),
    密码退出(5, "INPUT_QUIT", TradeCodeRefresh.刷新交易码),
    密码检查通过(6, "PWD_SUCCESS", TradeCodeRefresh.保持),
    等待选择卡套餐(7, "WAIT_SELECT", TradeCodeRefresh.保持),
    套餐退出(8, "SELECT_QUIT", TradeCodeRefresh.刷新交易码),
    选择卡套餐(9, "SELECT", TradeCodeRefresh.保持),
    卡套餐检查通过(10, "MEAL_SUCCESS", TradeCodeRefresh.保持),
    交易等待中(11, "TRADE_WAIT", TradeCodeRefresh.保持),
    交易开始(12, "TRADE_START", TradeCodeRefresh.保持),
    交易锁定(13, "TRADE_LOCK", TradeCodeRefresh.保持),
    云交易成功(14, "CLOUD_TRADE_SUCCESS", TradeCodeRefresh.保持),
    云交易查询(15, "CLOUD_TRADE_QUERY", TradeCodeRefresh.保持),
    交易成功(16, "TRADE_SUCCESS", TradeCodeRefresh.刷新交易码),
    交易失败(17, "TRADE_FAIL", TradeCodeRefresh.刷新交易码),
    取消交易(18, "CANCEL_TRADE", TradeCodeRefresh.刷新交易码),
    终端退出(19, "TD_QUIT", TradeCodeRefresh.刷新交易码),

    登出成功(20, "LOG_OUT_SUCCESS", TradeCodeRefresh.刷新交易码),
    登出失败(21, "LOG_OUT_FAIL", TradeCodeRefresh.保持),

    操作成功(22, "ACTION_SUCCESS", TradeCodeRefresh.刷新交易码),
    操作失败(23, "ACTION_FAIL", TradeCodeRefresh.刷新交易码),

    允许绑定(24, "CAN_BIND", TradeCodeRefresh.刷新交易码),
    禁止绑定(25, "CAN_NOT_BIND", TradeCodeRefresh.刷新交易码),

    交易撤销(26, "TRADE_REVOKE", TradeCodeRefresh.刷新交易码),
    ;

    // 状态码
    private final int code;
    // 交易状态
    private final String status;
    // 交易码状态刷新类型
    private final TradeCodeRefresh refresh;

    ChannelStatus(int code, String status, TradeCodeRefresh refresh) {
        this.code = code;
        this.status = status;
        this.refresh = refresh;
    }

    /**
     * @description: 状态信息
     **/
    public static ChannelStatus status(int code) {
        for (ChannelStatus value : ChannelStatus.values()) {
            if (value.code == code) return value;
        }
        return null;
    }

    /**
     * @description: 状态信息
     **/
    public static ChannelStatus status(String status) {
        if (StringUtils.isBlank(status)) return null;
        for (ChannelStatus tradeStatus : ChannelStatus.values()) {
            if (status.equals(tradeStatus.status)) return tradeStatus;
        }
        return null;
    }

    public int getCode() {
        return code;
    }

    public String getStatus() {
        return status;
    }

    public TradeCodeRefresh getRefresh() {
        return refresh;
    }
}
