package com.jhscale.common.model.device.polymerization.em;

public enum ENDState {

    Remove_Order(0, "取消订单[预创建订单取消，如已发生支付无法取消]"),
    Cancel_Order(1, "撤销订单[已发生的交易，直接退款]"),
    Close_Order(2, "关闭订单[支付中的订单关闭]");

    private final int state;

    private final String description;

    ENDState(int state, String description) {
        this.state = state;
        this.description = description;
    }

    public static ENDState state(int state) {
        for (ENDState value : ENDState.values()) {
            if (value.state == state) return value;
        }
        return null;
    }

    public int getState() {
        return state;
    }

    public String getDescription() {
        return description;
    }

    @Override
    public String toString() {
        return "ENDState{" +
                "state=" + state +
                ", description='" + description + '\'' +
                '}';
    }
}
