package com.jhscale.common.model.device.polymerization.em;

import org.apache.commons.lang3.StringUtils;

public enum HandleState {

    SUCCESS(0, "OK", "支付成功"),
    FAIL(1, "NO", "支付失败"),
    WAIT(2, "WT", "支付等待"),
    PAY_TIMEOUT(3, "PT", "支超时 "),
    BUILD_CREATE(4, "BC", "创建支付"),
    CLOSE(5, "CE", "订单关闭"),
    CANCEL(6, "CL", "订单撤销"),
    REMOVE(7, "RM", "订单取消"),
    ;

    private final int code;

    private final String state;

    private final String description;

    HandleState(int code, String state, String description) {
        this.code = code;
        this.state = state;
        this.description = description;
    }

    public static HandleState code(int code) {
        for (HandleState value : HandleState.values()) {
            if (value.code == code) return value;
        }
        return null;
    }

    public static HandleState state(String state) {
        if (StringUtils.isNotBlank(state)) {
            for (HandleState value : HandleState.values()) {
                if (value.getState().equals(state)) return value;
            }
        }
        return null;
    }

    public int getCode() {
        return code;
    }

    public String getState() {
        return state;
    }

    public String getDescription() {
        return description;
    }

    @Override
    public String toString() {
        return "HandleState{" +
                "code=" + code +
                ", state='" + state + '\'' +
                ", description='" + description + '\'' +
                '}';
    }
}
