package com.jhscale.common.model.device.polymerization.em;

import org.apache.commons.lang3.StringUtils;

public enum JKYTradeType {

    现金储值支付(1, "0B00", "现金储值支付"),
    云支付储值支付(2, "0C00", "云支付储值支付"),
    现金储值充值(3, "0D00", "现金储值充值"),
    云支付储值充值(4, "0E00", "云支付储值充值"),
    会员退款(5, "0F00", "吉卡云会员退款"),
    积分兑换(6, "+0A00", "吉卡云积分兑换"),
    会员注销(7, "+0B00", "吉卡云会员注销"),
    聚合储值支付(8, "+0C00", "吉卡云聚合储值支付"),
    聚合储值充值(9, "+0D00", "吉卡云聚合储值充值"),
    ;

    private final int type;

    private final String abbr;

    private String description;

    JKYTradeType(int type, String abbr, String description) {
        this.type = type;
        this.abbr = abbr;
        this.description = description;
    }

    public static JKYTradeType type(int type) {
        for (JKYTradeType value : JKYTradeType.values()) {
            if (value.type == type) return value;
        }
        return null;
    }

    public static JKYTradeType abbr(String abbr) {
        if (StringUtils.isBlank(abbr)) return null;
        for (JKYTradeType value : JKYTradeType.values()) {
            if (value.abbr.equals(abbr)) return value;
        }
        return null;
    }

    public int getType() {
        return type;
    }

    public String getAbbr() {
        return abbr;
    }

    public String getDescription() {
        return description;
    }
}
