package com.jhscale.common.model.device.polymerization.em;

import org.apache.commons.lang3.StringUtils;

public enum LoginType {

    小程序登陆("A"),
    实体卡登陆("B"),
    手机号码登陆("C"),
    手机号注册登陆("D");

    private final String type;

    LoginType(String type) {
        this.type = type;
    }

    /**
     * @description: 获取登陆类型
     **/
    public static LoginType type(String type) {
        if (StringUtils.isBlank(type)) return null;
        for (LoginType value : LoginType.values()) {
            if (String.valueOf(value.type).equals(type)) return value;
        }
        return null;
    }

    public String getType() {
        return type;
    }

    @Override
    public String toString() {
        return "LoginType{" +
                "type=" + type +
                '}';
    }
}
