package com.jhscale.common.model.device.polymerization.em;

import org.apache.commons.lang3.StringUtils;

public enum QRState {

    NEW_CODE(0, "NEW_CODE", "待扫码"),
    REPLACED(1, "REPLACED", "已替换"),
    INVALID(2, "INVALID", "已失效"),
    SCANNED(3, "SCANNED", "已扫码"),
    SUCCESS(4, "SUCCESS", "完成扫码"),
    FAIL(5, "FAIL", "扫码失败"),
    ;

    private final int code;

    private final String state;

    private final String description;

    QRState(int code, String type, String description) {
        this.code = code;
        this.state = type;
        this.description = description;
    }

    public static QRState code(int state) {
        for (QRState value : QRState.values()) {
            if (value.code == state) return value;
        }
        return null;
    }

    public static QRState state(String state) {
        if (StringUtils.isBlank(state)) return null;
        for (QRState value : QRState.values()) {
            if (value.state.equals(state)) return value;
        }
        return null;
    }

    public int getCode() {
        return code;
    }

    public String getState() {
        return state;
    }

    public String getDescription() {
        return description;
    }

    @Override
    public String toString() {
        return "QRState{" +
                "code=" + code +
                ", type='" + state + '\'' +
                ", description='" + description + '\'' +
                '}';
    }
}
