package com.jhscale.common.model.device.polymerization.em;

/**
 * @author wang lie
 * @version 1.0
 * @projectName common
 * @title QueryState
 * @description
 * @create 2024/1/23 10:54
 */
public enum QueryState {

    Local_Query(0, true, "本地查询"),
    VPS_Query(1, false, "第三方查询");

    private int state;

    private boolean local;

    private String description;

    QueryState(int state, boolean local, String description) {
        this.state = state;
        this.local = local;
        this.description = description;
    }

    public static QueryState state(int state) {
        for (QueryState value : QueryState.values()) {
            if (value.state == state) return value;
        }
        return null;
    }

    public int getState() {
        return state;
    }

    public boolean isLocal() {
        return local;
    }

    public String getDescription() {
        return description;
    }

    @Override
    public String toString() {
        return "QueryState{" +
                "state=" + state +
                ", local=" + local +
                ", description='" + description + '\'' +
                '}';
    }
}
