package com.jhscale.common.model.device.polymerization.em;

import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * @description: 原因
 **/
public enum Reason {
    客户主动退款(101, ReasonType.退款, "custom_refund", "客户主动退款"),
    商家主动退款(102, ReasonType.退款, "merchant_refund", "商家主动退款"),

    客户主动注销(201, ReasonType.注销, "custom_cancel", "客户主动注销"),
    商家主动注销(202, ReasonType.注销, "merchant_cancel", "商家主动注销"),
    ;

    private final int no;

    private final ReasonType type;

    private final String addr;

    private final String description;

    Reason(int no, ReasonType type, String addr, String description) {
        this.no = no;
        this.type = type;
        this.addr = addr;
        this.description = description;
    }

    public static Reason no(int no) {
        for (Reason value : Reason.values()) {
            if (value.no == no) return value;
        }
        return null;
    }

    public static Reason addr(String addr) {
        if (StringUtils.isNotBlank(addr)) {
            for (Reason value : Reason.values()) {
                if (value.addr.equals(addr)) return value;
            }
        }
        return null;
    }

    public static List<Reason> type(ReasonType type) {
        if (type != null) {
            List<Reason> reasons = null;
            for (Reason value : Reason.values()) {
                if (value.type.equals(type)) {
                    if (reasons == null) reasons = new ArrayList<>();
                    reasons.add(value);
                }
            }
            return reasons;
        }
        return null;
    }


    public int getNo() {
        return no;
    }

    public ReasonType getType() {
        return type;
    }

    public String getAddr() {
        return addr;
    }

    public String getDescription() {
        return description;
    }
}
