
package com.jhscale.common.model.device.polymerization.em;

import org.apache.commons.lang3.StringUtils;

/**
 * @description: 原因
 **/
public enum ReasonType {
    退款(1, "RF", "退款"),
    注销(2, "CL", "注销"),
    ;

    private final int no;

    private final String addr;

    private final String description;

    ReasonType(int no, String addr, String description) {
        this.no = no;
        this.addr = addr;
        this.description = description;
    }

    public static ReasonType no(int no) {
        for (ReasonType value : ReasonType.values()) {
            if (value.no == no) return value;
        }
        return null;
    }

    public static ReasonType addr(String addr) {
        if (StringUtils.isNotBlank(addr)) {
            for (ReasonType value : ReasonType.values()) {
                if (value.addr.equals(addr)) return value;
            }
        }
        return null;
    }


    public int getNo() {
        return no;
    }

    public String getAddr() {
        return addr;
    }

    public String getDescription() {
        return description;
    }
}
