package com.jhscale.common.model.device.polymerization.em;

import org.apache.commons.lang3.StringUtils;

/**
 * @author lie_w
 * @title: TradeExecute
 * @projectName member-core
 * @description: TODO
 * @date 2021/8/130:14
 */
public enum TradeCodeRefresh {

    刷新规则(1, "REFRESH_RULE"),
    刷新交易码(2, "REFRESH_CODE"),
    保持(0, "WAIT");

    private final int code;

    private final String auto;

    TradeCodeRefresh(int code, String auto) {
        this.code = code;
        this.auto = auto;
    }

    public static TradeCodeRefresh refresh(int code) {
        for (TradeCodeRefresh value : TradeCodeRefresh.values()) {
            if (code == value.code) return value;
        }
        return null;
    }

    public static TradeCodeRefresh refresh(String auto) {
        if (StringUtils.isBlank(auto)) return null;
        for (TradeCodeRefresh refresh : TradeCodeRefresh.values()) {
            if (auto.equals(refresh.auto)) return refresh;
        }
        return null;
    }

    public int getCode() {
        return code;
    }

    public String getAuto() {
        return auto;
    }
}
