package com.jhscale.common.model.device.polymerization.em;

import org.apache.commons.lang3.StringUtils;

/**
 * @author lie_w
 * @title: TradeEnv
 * @projectName member-core
 * @description: TODO
 * @date 2021/8/1023:39
 */
public enum TradeEnv {

    允许所有扣款方式(1, "A", "允许所有扣款方式"),
    允许储值扣款和储值混合扣款(2, "B", "允许储值扣款和储值混合扣款"),
    只允许储值扣款(3, "C", "只允许储值扣款"),
    只允许现金扣款(4, "D", "只允许现金扣款——交易情况=B/C时，如果余额=0，会自动进入冲值界面，如果交易情况=B，且余额不足时，会自动进入冲值界面");

    private final int code;

    private final String status;

    private final String description;

    TradeEnv(int code, String status, String description) {
        this.code = code;
        this.status = status;
        this.description = description;
    }

    /**
     * @description: 交易环境
     **/
    public static TradeEnv status(String statues) {
        if (StringUtils.isBlank(statues)) return null;
        for (TradeEnv tradeEnv : TradeEnv.values()) {
            if (tradeEnv.getStatus().equals(statues)) return tradeEnv;
        }
        return null;
    }

    public static TradeEnv status(int code) {
        for (TradeEnv tradeEnv : TradeEnv.values()) {
            if (tradeEnv.getCode() == code) return tradeEnv;
        }
        return null;
    }

    public int getCode() {
        return code;
    }

    public String getStatus() {
        return status;
    }

    public String getDescription() {
        return description;
    }
}
