package com.jhscale.common.model.device.polymerization.inner;

import com.jhscale.common.utils.ByteUtils;

/**
 * @author wang lie
 * @version 1.0
 * @projectName common
 * @title Mark
 * @description
 * @create 2024/1/22 16:51
 */
public class AggregatedMark implements POSCombination {

    private String hex;

    private String binary;

    private boolean encrypt;

    private boolean ack;

    private int cd;

    private int len;

    public AggregatedMark() {
    }

    public AggregatedMark(boolean encrypt, boolean ack) {
        this.encrypt = encrypt;
        this.ack = ack;
    }

    public AggregatedMark(String hex) {
        this.hex = hex;
    }

    /**
     * @param aesKey
     * @description: 组装
     */
    @Override
    public void assemble(String aesKey) {
        String binaryString = Integer.toBinaryString(this.len / 2);
        binaryString = binaryString.length() % 2 == 0 ? binaryString : ("0" + binaryString);

        StringBuilder builder = new StringBuilder();
        builder.append(this.encrypt ? '1' : '0')
                .append(this.ack ? '1' : '0')
                .append("00")
                .append(ByteUtils.appendFill(Integer.toBinaryString(this.cd), 2))
                .append(binaryString);
        this.binary = builder.toString();
        this.hex = ByteUtils.binaryToHex(this.binary);
    }

    /**
     * @param aesKey
     * @return
     * @description: 解析
     */
    @Override
    public boolean analyse(String aesKey) {
        this.binary = ByteUtils.formatMark(this.hex);
        this.encrypt = '1' == this.binary.charAt(0);
        this.ack = '1' == this.binary.charAt(1);
        this.cd = Integer.parseInt(this.binary.substring(4, 6), 2);
        this.len = Integer.parseInt(this.binary.substring(6, 8), 2) * 2;
        return false;
    }

    public String getHex() {
        return hex;
    }

    public AggregatedMark setHex(String hex) {
        this.hex = hex;
        return this;
    }

    public String getBinary() {
        return binary;
    }

    public AggregatedMark setBinary(String binary) {
        this.binary = binary;
        return this;
    }

    public boolean isEncrypt() {
        return encrypt;
    }

    public AggregatedMark setEncrypt(boolean encrypt) {
        this.encrypt = encrypt;
        return this;
    }

    public boolean isAck() {
        return ack;
    }

    public AggregatedMark setAck(boolean ack) {
        this.ack = ack;
        return this;
    }

    public int getCd() {
        return cd;
    }

    public AggregatedMark setCd(int cd) {
        this.cd = cd;
        return this;
    }

    public int getLen() {
        return len;
    }

    public AggregatedMark setLen(int len) {
        this.len = len;
        return this;
    }
}
