package com.jhscale.common.model.device.polymerization.inner;

import com.jhscale.common.utils.ByteUtils;

import java.math.BigDecimal;
import java.util.Objects;

/**
 * @author wang lie
 * @version 1.0
 * @projectName common
 * @title JKYDiscountLevel
 * @description
 * @create 2024/2/1 10:02
 */
public class JKYDiscountLevel extends AggregatedEntity {

    // 套餐等级
    private int id;

    // 等级 0 - 15 0 级 默认数据 特价：无 ， 折扣 100% ， 累计充值0
    private int grade;

    // 特价类型 ： 无 ， A , B ,C ,D
    private String specialType;

    // 折扣
    private BigDecimal discount;

    // 累进类型
    private String totalType;

    // 累进值
    private BigDecimal totalVal;

    /**
     * @description: 内包组装
     **/
    @Override
    public StringBuilder inner_assembly() {
        return new StringBuilder()
                .append(ByteUtils.int2HexWithPush(this.id, 8))
                .append(ByteUtils.int2Hex(this.grade))
                .append(ByteUtils.a_text(this.specialType))
                .append(ByteUtils.toSPFStrNone(this.discount()))
                .append(ByteUtils.a_text(this.totalType))
                .append(ByteUtils.toSPFStrNone(this.totalVal));
    }

    /**
     * @param innerContent
     * @description: 内包解析
     */
    @Override
    public String inner_analyse(String innerContent) {
        this.id = ByteUtils.hex2Ten(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);

        this.grade = ByteUtils.hex2Ten(innerContent.substring(0, 2));
        innerContent = innerContent.substring(2);

        int index = ByteUtils.indexOf(innerContent, "00");
        if (index != -1) {
            this.specialType = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }

        this.discount = ByteUtils.convertBigDecimalNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);

        index = ByteUtils.indexOf(innerContent, "00");
        if (index != -1) {
            this.totalType = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }

        this.totalVal = ByteUtils.convertBigDecimalNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);

        return innerContent;
    }

    public BigDecimal discount() {
        return Objects.nonNull(this.discount) ? this.discount : BigDecimal.ONE;
    }

    public int getId() {
        return id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getGrade() {
        return grade;
    }

    public void setGrade(int grade) {
        this.grade = grade;
    }

    public String getSpecialType() {
        return specialType;
    }

    public void setSpecialType(String specialType) {
        this.specialType = specialType;
    }

    public BigDecimal getDiscount() {
        return discount;
    }

    public void setDiscount(BigDecimal discount) {
        this.discount = discount;
    }

    public String getTotalType() {
        return totalType;
    }

    public void setTotalType(String totalType) {
        this.totalType = totalType;
    }

    public BigDecimal getTotalVal() {
        return totalVal;
    }

    public void setTotalVal(BigDecimal totalVal) {
        this.totalVal = totalVal;
    }
}
