package com.jhscale.common.model.device.polymerization.inner;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.jhscale.common.utils.ByteUtils;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author wang lie
 * @version 1.0
 * @projectName common
 * @title IntegralMeal
 * @description
 * @create 2024/2/1 11:01
 */
public class JKYIntegralSetMeal extends AggregatedEntity {

    // 套餐编号
    private String kid;

    // 套餐名称
    private String name;

    // 商户积分兑换序号
    private int mealOrder;

    // 兑换类别 0-物品兑换 1-赠送金额
    private String setMealType;

    // 赠送金额
    private BigDecimal money;

    // 使用积分
    private BigDecimal integral;

    // 兑换总数量
    private int totalDegree;

    // 兑换消耗量
    private int useDegree;

    // 套餐失效时间
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date mealLoseTime;

    // 有效标志 0-有效 1-失效
    private String lostType;

    /**
     * @description: 内包组装
     **/
    @Override
    public StringBuilder inner_assembly() {
        return new StringBuilder()
                .append(ByteUtils.a_text(this.kid))
                .append(ByteUtils.a_text(this.name))
                .append(ByteUtils.int2HexWithPush(this.mealOrder, 8))
                .append(ByteUtils.a_text(this.setMealType))
                .append(ByteUtils.toSPFStrNone(this.money))
                .append(ByteUtils.toSPFStrNone(this.integral))
                .append(ByteUtils.int2HexWithPush(this.totalDegree, 8))
                .append(ByteUtils.int2HexWithPush(this.useDegree, 8))
                .append(ByteUtils.timeToStr(this.mealLoseTime))
                .append(ByteUtils.a_text(this.lostType));
    }

    /**
     * @param innerContent
     * @description: 内包解析
     */
    @Override
    public String inner_analyse(String innerContent) {
        int index = ByteUtils.indexOf(innerContent, "00");
        if (index != -1) {
            this.kid = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }

        index = ByteUtils.indexOf(innerContent, "00");
        if (index != -1) {
            this.name = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }

        this.mealOrder = ByteUtils.hex2Ten(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);

        index = ByteUtils.indexOf(innerContent, "00");
        if (index != -1) {
            this.setMealType = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }

        this.money = ByteUtils.convertBigDecimalNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);

        this.integral = ByteUtils.convertBigDecimalNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);

        this.totalDegree = ByteUtils.hex2Ten(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);

        this.useDegree = ByteUtils.hex2Ten(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);

        this.mealLoseTime = ByteUtils.convertTimeNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);

        index = ByteUtils.indexOf(innerContent, "00");
        if (index != -1) {
            this.lostType = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }
        return innerContent;
    }

    public String getKid() {
        return kid;
    }

    public void setKid(String kid) {
        this.kid = kid;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getMealOrder() {
        return mealOrder;
    }

    public void setMealOrder(int mealOrder) {
        this.mealOrder = mealOrder;
    }

    public String getSetMealType() {
        return setMealType;
    }

    public void setSetMealType(String setMealType) {
        this.setMealType = setMealType;
    }

    public BigDecimal getMoney() {
        return money;
    }

    public void setMoney(BigDecimal money) {
        this.money = money;
    }

    public BigDecimal getIntegral() {
        return integral;
    }

    public void setIntegral(BigDecimal integral) {
        this.integral = integral;
    }

    public int getTotalDegree() {
        return totalDegree;
    }

    public void setTotalDegree(int totalDegree) {
        this.totalDegree = totalDegree;
    }

    public int getUseDegree() {
        return useDegree;
    }

    public void setUseDegree(int useDegree) {
        this.useDegree = useDegree;
    }

    public Date getMealLoseTime() {
        return mealLoseTime;
    }

    public void setMealLoseTime(Date mealLoseTime) {
        this.mealLoseTime = mealLoseTime;
    }

    public String getLostType() {
        return lostType;
    }

    public void setLostType(String lostType) {
        this.lostType = lostType;
    }
}
